/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.el;

import java.io.Serializable;
import javax.ejb.EJBTransactionRolledbackException;
import javax.el.BeanELResolver;
import javax.el.ELContext;
import javax.el.PropertyNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.platform.el.DocumentPropertyContext;
import org.nuxeo.ecm.platform.el.FieldAdapterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModelResolver
extends BeanELResolver {
    private static final Log log = LogFactory.getLog(DocumentModelResolver.class);

    public Class<?> getType(ELContext context, Object base, Object property) {
        Class type = null;
        if (base instanceof DocumentModel) {
            try {
                type = super.getType(context, base, property);
            }
            catch (PropertyNotFoundException e) {
                type = DocumentPropertyContext.class;
                context.setPropertyResolved(true);
            }
        } else if (base instanceof DocumentPropertyContext || base instanceof Property) {
            type = Object.class;
            context.setPropertyResolved(true);
        }
        return type;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        boolean avoidErrors = false;
        String errorMessage = null;
        Object value = null;
        if (base instanceof DocumentModel) {
            try {
                value = super.getValue(context, base, property);
            }
            catch (PropertyNotFoundException e) {
                value = new DocumentPropertyContext((DocumentModel)base, (String)property);
                context.setPropertyResolved(true);
            }
        } else if (base instanceof DocumentPropertyContext) {
            try {
                DocumentPropertyContext ctx = (DocumentPropertyContext)base;
                Property docProperty = ctx.doc.getProperty(ctx.schema + ":" + property);
                value = this.getDocumentPropertyValue(docProperty);
                context.setPropertyResolved(true);
            }
            catch (ClientException pe) {
                avoidErrors = true;
                errorMessage = pe.getMessage();
            }
        } else if (base instanceof Property) {
            try {
                Property docProperty = (Property)base;
                Property subProperty = this.getDocumentProperty(docProperty, property);
                value = this.getDocumentPropertyValue(subProperty);
                context.setPropertyResolved(true);
            }
            catch (PropertyException pe) {
                avoidErrors = true;
                errorMessage = pe.getMessage();
            }
        }
        if (!context.isPropertyResolved()) {
            try {
                value = super.getValue(context, base, property);
            }
            catch (Exception e) {
                Throwable t = e;
                do {
                    if (!(t instanceof EJBTransactionRolledbackException)) continue;
                    log.error((Object)t, t);
                    break;
                } while ((t = t.getCause()) != null);
                context.setPropertyResolved(false);
            }
        }
        if (!context.isPropertyResolved() && avoidErrors) {
            log.warn((Object)errorMessage);
            context.setPropertyResolved(true);
        }
        return value;
    }

    private Property getDocumentProperty(Property docProperty, Object propertyValue) throws PropertyException {
        Property subProperty = null;
        if ((docProperty instanceof ArrayProperty || docProperty instanceof ListProperty) && propertyValue instanceof Long) {
            subProperty = docProperty.get(((Long)propertyValue).intValue());
        } else if ((docProperty instanceof ArrayProperty || docProperty instanceof ListProperty) && propertyValue instanceof Integer) {
            Integer idx = (Integer)propertyValue;
            if (idx < docProperty.size()) {
                subProperty = docProperty.get(((Integer)propertyValue).intValue());
            }
        } else if (docProperty instanceof ComplexProperty && propertyValue instanceof String) {
            subProperty = docProperty.get((String)propertyValue);
        }
        if (subProperty == null) {
            throw new PropertyException(String.format("Could not resolve subproperty '%s' under '%s'", propertyValue, docProperty.getPath()));
        }
        return subProperty;
    }

    private Object getDocumentPropertyValue(Property docProperty) throws PropertyException {
        if (docProperty == null) {
            throw new PropertyException("Null property");
        }
        Object value = docProperty;
        if (!docProperty.isContainer()) {
            value = docProperty.getValue();
            value = FieldAdapterManager.getValueForDisplay(value);
        }
        return value;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        boolean readOnly;
        block3: {
            readOnly = false;
            try {
                readOnly = super.isReadOnly(context, base, property);
            }
            catch (PropertyNotFoundException e) {
                if (base instanceof DocumentModel || base instanceof DocumentPropertyContext) {
                    readOnly = false;
                    context.setPropertyResolved(true);
                }
                if (!(base instanceof Property)) break block3;
                readOnly = ((Property)base).isReadOnly();
                context.setPropertyResolved(true);
            }
        }
        return readOnly;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof DocumentModel) {
            try {
                super.setValue(context, base, property, value);
            }
            catch (PropertyNotFoundException e) {}
        } else if (base instanceof DocumentPropertyContext) {
            DocumentPropertyContext ctx = (DocumentPropertyContext)base;
            value = FieldAdapterManager.getValueForStorage(value);
            try {
                ctx.doc.setPropertyValue(ctx.schema + ":" + (String)property, (Serializable)value);
                context.setPropertyResolved(true);
            }
            catch (ClientException e) {
                log.warn((Object)e.getMessage());
                context.setPropertyResolved(true);
            }
        } else if (base instanceof Property) {
            try {
                Property docProperty = (Property)base;
                Property subProperty = this.getDocumentProperty(docProperty, property);
                value = FieldAdapterManager.getValueForStorage(value);
                subProperty.setValue(value);
                context.setPropertyResolved(true);
            }
            catch (PropertyException pe) {
                log.warn((Object)pe.getMessage());
                context.setPropertyResolved(true);
            }
        }
    }
}

