/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.mime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.wom.api.binding.wsdl11.mime.MimeContent;
import org.jvnet.wom.api.binding.wsdl11.mime.MimePart;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPBodyImpl;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimePartImpl
implements MimePart {
    private final Locator locator;
    private final String partName;
    private final List<MimeContent> contents = new ArrayList<MimeContent>();
    private final Map<String, List<String>> contentMap = new HashMap<String, List<String>>();
    private SOAPBodyImpl bodyPart;

    public MimePartImpl(String partName, Locator locator) {
        this.partName = partName;
        this.locator = locator;
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    public void setBodyPart(SOAPBodyImpl part) {
        this.bodyPart = part;
    }

    @Override
    public SOAPBodyImpl getBodyPart() {
        return this.bodyPart;
    }

    @Override
    public Collection<MimeContent> getMimeContentParts() {
        return this.contents;
    }

    public void addMimeContent(MimeContent mimeContent) {
        if (this.contentMap.get(mimeContent.getPartName()) == null) {
            ArrayList<String> contentTypes = new ArrayList<String>();
            contentTypes.add(mimeContent.getType());
            this.contentMap.put(mimeContent.getPartName(), contentTypes);
        } else {
            this.contentMap.get(mimeContent.getPartName()).add(mimeContent.getType());
        }
        this.contents.add(mimeContent);
    }

    @Override
    public Collection<String> getMimeContentType(String mimePart) {
        return this.contentMap.get(mimePart);
    }
}

