/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.privateutil;

import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PolicyLogger {
    private static final String POLICY_PACKAGE_ROOT = "com.sun.xml.ws.policy";
    private static final String LOGGING_SUBSYSTEM_NAME;
    private static final Level METHOD_CALL_LEVEL_VALUE;
    private final String componentClassName;
    private final Logger logger;

    private PolicyLogger(String componentName) {
        this.componentClassName = "[" + componentName + "] ";
        this.logger = componentName.startsWith(POLICY_PACKAGE_ROOT) ? Logger.getLogger(LOGGING_SUBSYSTEM_NAME + componentName.substring(POLICY_PACKAGE_ROOT.length())) : Logger.getLogger(LOGGING_SUBSYSTEM_NAME + "." + componentName);
    }

    public static PolicyLogger getLogger(Class componentClass) {
        return new PolicyLogger(componentClass.getName());
    }

    public void log(Level level, String message) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void log(Level level, String message, Throwable thrown) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public void finest(String message) {
        if (!this.logger.isLoggable(Level.FINEST)) {
            return;
        }
        this.logger.logp(Level.FINEST, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void finest(String message, Throwable thrown) {
        if (!this.logger.isLoggable(Level.FINEST)) {
            return;
        }
        this.logger.logp(Level.FINEST, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public void finer(String message) {
        if (!this.logger.isLoggable(Level.FINER)) {
            return;
        }
        this.logger.logp(Level.FINER, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void finer(String message, Throwable thrown) {
        if (!this.logger.isLoggable(Level.FINER)) {
            return;
        }
        this.logger.logp(Level.FINER, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public void fine(String message) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        this.logger.logp(Level.FINE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void fine(String message, Throwable thrown) {
        if (!this.logger.isLoggable(Level.FINE)) {
            return;
        }
        this.logger.logp(Level.FINE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public void info(String message) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.logp(Level.INFO, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void info(String message, Throwable thrown) {
        if (!this.logger.isLoggable(Level.INFO)) {
            return;
        }
        this.logger.logp(Level.INFO, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public void config(String message) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.logp(Level.CONFIG, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void config(String message, Throwable thrown) {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.logp(Level.CONFIG, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public void warning(String message) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        this.logger.logp(Level.WARNING, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void warning(String message, Throwable thrown) {
        if (!this.logger.isLoggable(Level.WARNING)) {
            return;
        }
        this.logger.logp(Level.WARNING, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public void severe(String message) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message);
    }

    public void severe(String message, Throwable thrown) {
        if (!this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), message, thrown);
    }

    public boolean isMethodCallLoggable() {
        return this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE);
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    public void entering() {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.entering(this.componentClassName, PolicyUtils.Commons.getCallerMethodName());
    }

    public void entering(Object ... parameters) {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.entering(this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), parameters);
    }

    public void exiting() {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.exiting(this.componentClassName, PolicyUtils.Commons.getCallerMethodName());
    }

    public void exiting(Object result) {
        if (!this.logger.isLoggable(METHOD_CALL_LEVEL_VALUE)) {
            return;
        }
        this.logger.exiting(this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), result);
    }

    public <T extends Throwable> T logSevereException(T exception, Throwable cause) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (cause == null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage());
            } else {
                exception.initCause(cause);
                this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage(), cause);
            }
        }
        return exception;
    }

    public <T extends Throwable> T logSevereException(T exception, boolean logCause) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (logCause && exception.getCause() != null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage(), exception.getCause());
            } else {
                this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage());
            }
        }
        return exception;
    }

    public <T extends Throwable> T logSevereException(T exception) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            if (exception.getCause() == null) {
                this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage());
            } else {
                this.logger.logp(Level.SEVERE, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage(), exception.getCause());
            }
        }
        return exception;
    }

    public <T extends Throwable> T logException(T exception, Throwable cause, Level level) {
        if (this.logger.isLoggable(level)) {
            if (cause == null) {
                this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage());
            } else {
                exception.initCause(cause);
                this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage(), cause);
            }
        }
        return exception;
    }

    public <T extends Throwable> T logException(T exception, boolean logCause, Level level) {
        if (this.logger.isLoggable(level)) {
            if (logCause && exception.getCause() != null) {
                this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage(), exception.getCause());
            } else {
                this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage());
            }
        }
        return exception;
    }

    public <T extends Throwable> T logException(T exception, Level level) {
        if (this.logger.isLoggable(level)) {
            if (exception.getCause() == null) {
                this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage());
            } else {
                this.logger.logp(level, this.componentClassName, PolicyUtils.Commons.getCallerMethodName(), exception.getMessage(), exception.getCause());
            }
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        METHOD_CALL_LEVEL_VALUE = Level.FINEST;
        String loggingSubsystemName = "wspolicy";
        try {
            Class<?> jaxwsConstants = Class.forName("com.sun.xml.ws.util.Constants");
            Field loggingDomainField = jaxwsConstants.getField("LoggingDomain");
            Object loggingDomain = loggingDomainField.get(null);
            loggingSubsystemName = loggingDomain.toString().concat(".wspolicy");
        }
        catch (Exception e) {
            loggingSubsystemName = "wspolicy";
        }
        finally {
            LOGGING_SUBSYSTEM_NAME = loggingSubsystemName;
        }
    }
}

