/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.types.FieldWidget;
import org.nuxeo.ecm.platform.types.Layouts;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.TypeRegistry;
import org.nuxeo.ecm.platform.types.TypeView;
import org.nuxeo.ecm.platform.types.TypeWidget;
import org.nuxeo.ecm.platform.types.TypeWidgetRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeService
extends DefaultComponent
implements TypeManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.types.TypeService");
    private static final Log log = LogFactory.getLog(TypeService.class);
    private TypeRegistry typeRegistry;
    private TypeWidgetRegistry typeWidgetRegistry;

    public void activate(ComponentContext context) {
        this.typeRegistry = new TypeRegistry();
        this.typeWidgetRegistry = new TypeWidgetRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.typeRegistry = null;
        this.typeWidgetRegistry = null;
    }

    public void registerExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("types")) {
            this.registerTypeExtension(extension);
        } else if (xp.equals("default_layout")) {
            this.registerTypeWidgetExtension(extension);
        }
    }

    public void unregisterExtension(Extension extension) {
        String xp = extension.getExtensionPoint();
        if (xp.equals("types")) {
            this.unregisterTypeExtension(extension);
        }
        if (xp.equals("default_layout")) {
            this.unregisterTypeWidgetExtension(extension);
        }
    }

    public void registerTypeExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            Type type = (Type)contrib;
            String typeId = type.getId();
            if (type.getRemove()) {
                log.debug((Object)("Removing type with id " + typeId));
                this.typeRegistry.removeType(typeId);
                continue;
            }
            if (this.typeRegistry.hasType(typeId)) {
                type = TypeService.mergeTypes(this.typeRegistry.getType(typeId), type);
                this.typeRegistry.removeType(typeId);
                log.debug((Object)("Merging type with id " + typeId));
            }
            this.typeRegistry.addType(type);
            log.info((Object)("Registered platform document type: " + typeId));
        }
    }

    public void unregisterTypeExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            Type type = (Type)contrib;
            this.typeRegistry.removeType(type.getId());
        }
    }

    public static Type mergeTypes(Type oldType, Type newType) {
        Map layouts;
        String editView;
        String createView;
        Map newTypeAllowedSubTypes;
        String category;
        String description;
        String label;
        String bigIconExpanded;
        String bigIcon;
        String iconExpanded;
        String icon = newType.getIcon();
        if (icon != null) {
            oldType.setIcon(icon);
        }
        if ((iconExpanded = newType.getIconExpanded()) != null) {
            oldType.setIconExpanded(iconExpanded);
        }
        if ((bigIcon = newType.getBigIcon()) != null) {
            oldType.setBigIcon(bigIcon);
        }
        if ((bigIconExpanded = newType.getBigIconExpanded()) != null) {
            oldType.setBigIconExpanded(bigIconExpanded);
        }
        if ((label = newType.getLabel()) != null) {
            oldType.setLabel(label);
        }
        if ((description = newType.getDescription()) != null) {
            oldType.setDescription(description);
        }
        if ((category = newType.getCategory()) != null) {
            oldType.setCategory(category);
        }
        if ((newTypeAllowedSubTypes = newType.getAllowedSubTypes()) != null) {
            Set newTypeKeySet = newTypeAllowedSubTypes.keySet();
            Map oldTypeAllowedSubTypes = oldType.getAllowedSubTypes();
            for (String newTypeKey : newTypeKeySet) {
                oldTypeAllowedSubTypes.put(newTypeKey, newTypeAllowedSubTypes.get(newTypeKey));
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] deniedSubTypes = newType.getDeniedSubTypes();
        Map oldTypeAllowedSubTypes = oldType.getAllowedSubTypes();
        boolean toAdd = true;
        if (oldTypeAllowedSubTypes != null) {
            Set oldTypeKeySet = oldTypeAllowedSubTypes.keySet();
            for (String allowedSubType : oldTypeKeySet) {
                for (String deniedSubType : deniedSubTypes) {
                    if (!deniedSubType.equals(allowedSubType)) continue;
                    toAdd = false;
                    break;
                }
                if (toAdd) {
                    result.add(allowedSubType);
                }
                toAdd = true;
            }
        }
        HashMap mapResult = new HashMap();
        for (String resultTypeName : result) {
            mapResult.put(resultTypeName, oldTypeAllowedSubTypes.get(resultTypeName));
        }
        oldType.setAllowedSubTypes(mapResult);
        String defaultView = newType.getDefaultView();
        if (defaultView != null) {
            oldType.setDefaultView(defaultView);
        }
        if ((createView = newType.getCreateView()) != null) {
            oldType.setCreateView(createView);
        }
        if ((editView = newType.getEditView()) != null) {
            oldType.setEditView(editView);
        }
        for (TypeView view : newType.getViews()) {
            oldType.setView(view);
        }
        FieldWidget[] layout = newType.getLayout();
        if (layout != null && layout.length != 0) {
            oldType.setLayout(layout);
        }
        if ((layouts = newType.getLayouts()) != null) {
            HashMap<String, Layouts> layoutsMerged = new HashMap<String, Layouts>(oldType.getLayouts());
            for (Map.Entry entry : layouts.entrySet()) {
                String key = (String)entry.getKey();
                Layouts newLayouts = (Layouts)entry.getValue();
                if (layoutsMerged.containsKey(key) && newLayouts.getAppend()) {
                    ArrayList<String> allLayouts = new ArrayList<String>();
                    for (String layoutName : ((Layouts)layoutsMerged.get(key)).getLayouts()) {
                        allLayouts.add(layoutName);
                    }
                    for (String layoutName : newLayouts.getLayouts()) {
                        allLayouts.add(layoutName);
                    }
                    Layouts mergedLayouts = new Layouts();
                    mergedLayouts.layouts = allLayouts.toArray(new String[allLayouts.size()]);
                    layoutsMerged.put(key, mergedLayouts);
                    continue;
                }
                layoutsMerged.put(key, newLayouts);
            }
            oldType.setLayouts(layoutsMerged);
        }
        return oldType;
    }

    public void registerTypeWidgetExtension(Extension extension) {
        Object[] contribs = extension.getContributions();
        log.warn((Object)"The type widget contribution system is deprecated, use the new layout system instead");
        for (Object contrib : contribs) {
            TypeWidget typeWidget = (TypeWidget)contrib;
            this.typeWidgetRegistry.addTypeWidget(typeWidget);
        }
    }

    public void unregisterTypeWidgetExtension(Extension extension) {
        Object[] contribs;
        for (Object contrib : contribs = extension.getContributions()) {
            TypeWidget typeWidget = (TypeWidget)contrib;
            this.typeWidgetRegistry.removeTypeWidget(typeWidget.getFieldtype());
        }
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public TypeWidgetRegistry getTypeWidgetRegistry() {
        return this.typeWidgetRegistry;
    }

    public String[] getSuperTypes(String typeName) {
        try {
            SchemaManager schemaMgr = (SchemaManager)Framework.getService(SchemaManager.class);
            DocumentType type = schemaMgr.getDocumentType(typeName);
            if (type == null) {
                return null;
            }
            ArrayList<String> superTypes = new ArrayList<String>();
            for (type = (DocumentType)type.getSuperType(); type != null; type = (DocumentType)type.getSuperType()) {
                superTypes.add(type.getName());
            }
            return superTypes.toArray(new String[superTypes.size()]);
        }
        catch (Exception e) {
            log.error((Object)"Failed to lookup the SchemaManager service", (Throwable)e);
            return new String[0];
        }
    }

    public Type getType(String typeName) {
        return this.typeRegistry.getType(typeName);
    }

    public boolean hasType(String typeName) {
        return this.typeRegistry.hasType(typeName);
    }

    public Collection<Type> getTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        types.addAll(this.typeRegistry.getTypes());
        return types;
    }

    public Collection<Type> getAllowedSubTypes(String typeName) {
        ArrayList<Type> allowed = new ArrayList<Type>();
        Type type = this.getType(typeName);
        if (type != null) {
            for (String subTypeName : type.getAllowedSubTypes().keySet()) {
                Type subType = this.getType(subTypeName);
                if (subType == null) continue;
                allowed.add(subType);
            }
        }
        return allowed;
    }
}

