/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.types.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeRegistry {
    private static final Log log = LogFactory.getLog(TypeRegistry.class);
    final Map<String, Type> types = new HashMap<String, Type>();

    public synchronized void addType(Type type) {
        String id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering type: " + type));
        }
        if (!this.types.containsKey(id = type.getId())) {
            this.types.put(id, type);
        }
    }

    public synchronized boolean hasType(String id) {
        return this.types.containsKey(id);
    }

    public synchronized Type removeType(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering type: " + id));
        }
        return this.types.remove(id);
    }

    public synchronized Collection<Type> getTypes() {
        return Collections.unmodifiableCollection(this.types.values());
    }

    public Type getType(String id) {
        return this.types.get(id);
    }
}

