/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;

public class ExtendedDocumentLocation
extends DocumentLocationImpl
implements DocumentLocation {
    private static final long serialVersionUID = 1L;
    protected String originalServer = null;

    public ExtendedDocumentLocation(String serverName, DocumentRef docRef) {
        super(serverName, docRef);
    }

    public ExtendedDocumentLocation(String originalServer, String serverName, DocumentRef docRef) {
        super(serverName, docRef);
        this.originalServer = originalServer;
    }

    public ExtendedDocumentLocation(String originalServer, DocumentModel doc) {
        super(doc);
        this.originalServer = originalServer;
    }

    public String getOriginalServer() {
        return this.originalServer;
    }

    public String toString() {
        return this.getServerName() + "@" + this.getOriginalServer() + ":" + this.getDocRef().toString();
    }

    public static ExtendedDocumentLocation parseString(String source) {
        String[] refParts = source.split("@");
        String sourceServer = refParts[1].split(":")[0];
        String repositoryName = refParts[0];
        IdRef ref = new IdRef(refParts[1].split(":")[1]);
        return new ExtendedDocumentLocation(sourceServer, repositoryName, (DocumentRef)ref);
    }

    public static ExtendedDocumentLocation extractFromDoc(DocumentModel doc) throws ClientException {
        String source;
        if (doc.hasSchema("dublincore") && (source = (String)doc.getProperty("dublincore", "source")) != null) {
            return ExtendedDocumentLocation.parseString(source);
        }
        return null;
    }
}

