/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.marshaling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.AbstractDefaultXMLMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.CoreIODocumentModelMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.DefaultDocumentLocationMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.DefaultPublicationNodeMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.DefaultPublishedDocumentMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.DocumentLocationMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.DocumentModelMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.PublicationNodeMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.PublishedDocumentMarshaler;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.PublishingMarshalingException;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.interfaces.RemotePublisherMarshaler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMarshaler
extends AbstractDefaultXMLMarshaler
implements RemotePublisherMarshaler {
    private static final String PARAM_PATTERN = "$PARAM";
    private static final String RESULT_PATTERN = "$RESULT$";
    protected PublicationNodeMarshaler nodeMarshaler;
    protected PublishedDocumentMarshaler publishedDocumentMarshaler;
    protected DocumentModelMarshaler documentModelMarshaler;
    protected DocumentLocationMarshaler docLocMarshaler;
    protected Map<String, String> params = new HashMap<String, String>();
    protected static QName rootParametersTag = DocumentFactory.getInstance().createQName("parameters", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName parameterTag = DocumentFactory.getInstance().createQName("parameter", "nxpub", "http://www.nuxeo.org/publisher");
    protected static QName rootResultTag = DocumentFactory.getInstance().createQName("result", "nxpub", "http://www.nuxeo.org/publisher");
    protected CoreSession session;

    public DefaultMarshaler() {
        this(null);
    }

    public DefaultMarshaler(CoreSession session) {
        this.nodeMarshaler = new DefaultPublicationNodeMarshaler();
        this.publishedDocumentMarshaler = new DefaultPublishedDocumentMarshaler();
        this.documentModelMarshaler = new CoreIODocumentModelMarshaler();
        this.docLocMarshaler = new DefaultDocumentLocationMarshaler();
        this.session = session;
    }

    public String marshallParameters(List<Object> params) throws PublishingMarshalingException {
        if (params == null) {
            return "null";
        }
        String env = this.buildParameterEnvelope(params.size());
        int idx = 1;
        for (Object param : params) {
            String strParam = this.marshalSingleObject(param);
            env = env.replace(PARAM_PATTERN + idx + "$", strParam);
            ++idx;
        }
        return env;
    }

    public String marshallResult(Object result) throws PublishingMarshalingException {
        String res = this.buildResultEnvelope();
        String strResult = this.marshalSingleObject(result);
        res = res.replace(RESULT_PATTERN, strResult);
        return res;
    }

    public List<Object> unMarshallParameters(String data) throws PublishingMarshalingException {
        return this.unMarshallParameters(data, this.session);
    }

    protected List<Object> unMarshallParameters(String data, CoreSession session) throws PublishingMarshalingException {
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            Document document = DocumentHelper.parseText((String)data);
            Element rootElem = document.getRootElement();
            Iterator i = rootElem.elementIterator(parameterTag);
            while (i.hasNext()) {
                Element param = (Element)i.next();
                if (param.elements().size() > 0) {
                    String xmlParam = ((Element)param.elements().get(0)).asXML();
                    params.add(this.unMarshalSingleObject(xmlParam, session));
                    continue;
                }
                String value = param.getText();
                if ("null".equals(value)) {
                    value = null;
                }
                params.add(value);
            }
        }
        catch (DocumentException e) {
            throw new PublishingMarshalingException("Error during unmarshaling of parameters", (Throwable)e);
        }
        return params;
    }

    public Object unMarshallResult(String data) throws PublishingMarshalingException {
        return this.unMarshallResult(data, this.session);
    }

    protected Object unMarshallResult(String data, CoreSession coreSession) throws PublishingMarshalingException {
        try {
            Document document = DocumentHelper.parseText((String)data);
            Element rootElem = document.getRootElement();
            if (rootElem.elements().size() == 0) {
                return rootElem.getText();
            }
            return this.unMarshalSingleObject(((Element)rootElem.elements().get(0)).asXML(), coreSession);
        }
        catch (DocumentException e) {
            throw new PublishingMarshalingException("Error during unmarshaling Result", (Throwable)e);
        }
    }

    protected String buildParameterEnvelope(int nbParams) {
        Element rootElem = DocumentFactory.getInstance().createElement(rootParametersTag);
        rootElem.addNamespace("nxpub", "http://www.nuxeo.org/publisher");
        Document rootDoc = DocumentFactory.getInstance().createDocument(rootElem);
        for (int i = 1; i <= nbParams; ++i) {
            Element pathElem = rootElem.addElement(parameterTag);
            pathElem.setText(PARAM_PATTERN + i + "$");
        }
        return rootDoc.asXML();
    }

    protected String buildResultEnvelope() {
        Element rootElem = DocumentFactory.getInstance().createElement(rootResultTag);
        rootElem.addNamespace("nxpub", "http://www.nuxeo.org/publisher");
        Document rootDoc = DocumentFactory.getInstance().createDocument(rootElem);
        rootElem.setText(RESULT_PATTERN);
        return rootDoc.asXML();
    }

    protected Object unMarshalSingleObject(String xml, CoreSession coreSession) throws PublishingMarshalingException {
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element rootElem = document.getRootElement();
            QName qname = rootElem.getQName();
            String name = rootElem.getName();
            if (name.equals("publicationNode")) {
                return this.nodeMarshaler.unMarshalPublicationNode(xml);
            }
            if (name.equals("publishedDocument")) {
                return this.publishedDocumentMarshaler.unMarshalPublishedDocument(xml);
            }
            if (name.equals("document")) {
                return this.documentModelMarshaler.unMarshalDocument(xml, coreSession);
            }
            if (name.equals("documentLocation")) {
                return this.docLocMarshaler.unMarshalDocumentLocation(xml);
            }
            if (name.equals("list")) {
                ArrayList<Object> lst = new ArrayList<Object>();
                Iterator i = rootElem.elementIterator("listitem");
                while (i.hasNext()) {
                    Element el = (Element)i.next();
                    if (el.elements().size() == 0) {
                        lst.add(el.getText());
                        continue;
                    }
                    lst.add(this.unMarshalSingleObject(((Element)el.elements().get(0)).asXML(), coreSession));
                }
                return lst;
            }
            if (name.equals("map")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator i = rootElem.elementIterator("mapitem");
                while (i.hasNext()) {
                    Element el = (Element)i.next();
                    Object value = null;
                    value = el.elements().size() > 0 ? this.unMarshalSingleObject(((Element)el.elements().get(0)).asXML(), coreSession) : el.getText();
                    String key = el.attributeValue("name");
                    map.put(key, value);
                }
                return map;
            }
        }
        catch (Throwable e) {
            throw new PublishingMarshalingException("Error during unmarshaling", e);
        }
        throw new PublishingMarshalingException("Unable to unmarshal data");
    }

    protected String marshalSingleObject(Object ob) throws PublishingMarshalingException {
        if (ob == null) {
            return "null";
        }
        if (ob instanceof String) {
            return (String)ob;
        }
        if (ob instanceof DocumentModel) {
            return this.cleanUpXml(this.documentModelMarshaler.marshalDocument((DocumentModel)ob));
        }
        if (ob instanceof PublicationNode) {
            return this.nodeMarshaler.marshalPublicationNode((PublicationNode)ob);
        }
        if (ob instanceof PublishedDocument) {
            return this.publishedDocumentMarshaler.marshalPublishedDocument((PublishedDocument)ob);
        }
        if (ob instanceof DocumentLocation) {
            return this.docLocMarshaler.marshalDocumentLocation((DocumentLocation)ob);
        }
        if (ob instanceof List) {
            StringBuffer sb = new StringBuffer();
            sb.append("<list>");
            List list = (List)ob;
            for (Object itemOb : list) {
                sb.append("<listitem>");
                sb.append(this.marshalSingleObject(itemOb));
                sb.append("</listitem>");
            }
            sb.append("</list>");
            return sb.toString();
        }
        if (ob instanceof Map) {
            StringBuffer sb = new StringBuffer();
            sb.append("<map>");
            Map map = (Map)ob;
            for (Object key : map.keySet()) {
                sb.append("<mapitem ");
                sb.append("name=\"");
                sb.append((String)key);
                sb.append("\">");
                sb.append(this.marshalSingleObject(map.get(key)));
                sb.append("</mapitem>");
            }
            sb.append("</map>");
            return sb.toString();
        }
        throw new PublishingMarshalingException("unable to marshal object");
    }

    public void setAssociatedCoreSession(CoreSession session) {
        this.session = session;
    }

    public void setParameters(Map<String, String> params) {
        this.params.putAll(params);
        this.docLocMarshaler.setOriginatingServer(params.get("originalServer"));
        this.documentModelMarshaler.setOriginatingServer(params.get("originalServer"));
    }
}

