/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemotableTree
implements PublicationTree {
    private static final Log log = LogFactory.getLog(AbstractRemotableTree.class);
    protected RemotePublicationTreeManager treeService = null;
    protected String sessionId;
    protected String configName;
    protected boolean released = false;

    protected abstract RemotePublicationTreeManager getTreeService() throws ClientException;

    protected abstract String getTargetTreeName();

    protected abstract String getServerTreeSessionId();

    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) throws ClientException {
        return this.getTreeService().getExistingPublishedDocument(this.getServerTreeSessionId(), docLoc);
    }

    public List<PublishedDocument> getPublishedDocumentInNode(PublicationNode node) throws ClientException {
        return this.getTreeService().getPublishedDocumentInNode(this.switchToServerNode(node));
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        return this.publish(doc, targetNode, null);
    }

    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        return this.getTreeService().publish(doc, this.switchToServerNode(targetNode), params);
    }

    public void unpublish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        this.getTreeService().unpublish(doc, this.switchToServerNode(targetNode));
    }

    public void unpublish(PublishedDocument publishedDocument) throws ClientException {
        this.getTreeService().unpublish(this.getServerTreeSessionId(), publishedDocument);
    }

    protected abstract PublicationNode switchToClientNode(PublicationNode var1) throws ClientException;

    protected abstract PublicationNode switchToServerNode(PublicationNode var1);

    protected List<PublicationNode> switchToClientNodes(List<PublicationNode> nodes) throws ClientException {
        ArrayList<PublicationNode> wrappedNodes = new ArrayList<PublicationNode>();
        for (PublicationNode node : nodes) {
            wrappedNodes.add(this.switchToClientNode(node));
        }
        return wrappedNodes;
    }

    public PublicationNode getNodeByPath(String path) throws ClientException {
        return this.switchToClientNode(this.getTreeService().getNodeByPath(this.getServerTreeSessionId(), path));
    }

    public String getConfigName() {
        return this.configName;
    }

    public PublicationNode getParent() {
        return null;
    }

    public void setCurrentDocument(DocumentModel currentDocument) throws ClientException {
        this.getTreeService().setCurrentDocument(this.getServerTreeSessionId(), currentDocument);
    }

    public void release() {
        try {
            if (!this.released) {
                this.getTreeService().release(this.getServerTreeSessionId());
            }
            this.released = true;
        }
        catch (ClientException e) {
            log.error((Object)"Error during release", (Throwable)e);
        }
    }

    public void validatorPublishDocument(PublishedDocument publishedDocument, String comment) throws ClientException {
        this.getTreeService().validatorPublishDocument(this.getServerTreeSessionId(), publishedDocument, comment);
    }

    public void validatorRejectPublication(PublishedDocument publishedDocument, String comment) throws ClientException {
        this.getTreeService().validatorRejectPublication(this.getServerTreeSessionId(), publishedDocument, comment);
    }

    public boolean canPublishTo(PublicationNode publicationNode) throws ClientException {
        return this.getTreeService().canPublishTo(this.getServerTreeSessionId(), publicationNode);
    }

    public boolean canUnpublish(PublishedDocument publishedDocument) throws ClientException {
        return this.getTreeService().canUnpublish(this.getServerTreeSessionId(), publishedDocument);
    }

    public boolean hasValidationTask(PublishedDocument publishedDocument) throws ClientException {
        return this.getTreeService().hasValidationTask(this.getServerTreeSessionId(), publishedDocument);
    }

    public boolean canManagePublishing(PublishedDocument publishedDocument) throws ClientException {
        return this.getTreeService().canManagePublishing(this.getServerTreeSessionId(), publishedDocument);
    }

    public PublishedDocument wrapToPublishedDocument(DocumentModel documentModel) throws ClientException {
        return this.getTreeService().wrapToPublishedDocument(this.getServerTreeSessionId(), documentModel);
    }

    public boolean isPublicationNode(DocumentModel documentModel) throws ClientException {
        return this.getTreeService().isPublicationNode(this.getServerTreeSessionId(), documentModel);
    }

    public PublicationNode wrapToPublicationNode(DocumentModel documentModel) throws ClientException {
        return this.getTreeService().wrapToPublicationNode(this.getServerTreeSessionId(), documentModel);
    }
}

