/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.publisher.api.AbstractPublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualCoreFolderPublicationNode
extends AbstractPublicationNode {
    protected static String ACCESSIBLE_CHILDREN_QUERY = "SELECT * FROM Document WHERE ecm:primaryType = 'Section' AND ecm:path STARTSWITH '%s' AND ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0  AND ecm:currentLifeCycleState != 'deleted' ";
    protected String coreSessionId;
    protected String path;
    protected String treeConfigName;
    protected PublishedDocumentFactory factory;
    protected String sid;

    public VirtualCoreFolderPublicationNode(String coreSessionId, String documentPath, String treeConfigName, String sid, PublishedDocumentFactory factory) {
        this.coreSessionId = coreSessionId;
        this.path = documentPath;
        this.treeConfigName = treeConfigName;
        this.factory = factory;
        this.sid = sid;
    }

    public String getTitle() throws ClientException {
        return "Sections";
    }

    public String getName() throws ClientException {
        return "sections";
    }

    public PublicationNode getParent() {
        return null;
    }

    public List<PublicationNode> getChildrenNodes() throws ClientException {
        ArrayList<PublicationNode> childrenNodes = new ArrayList<PublicationNode>();
        CoreSession session = this.getCoreSession();
        if (session != null) {
            String query = String.format(ACCESSIBLE_CHILDREN_QUERY, this.path);
            DocumentModelList docs = session.query(query);
            for (DocumentModel doc : docs) {
                Path path = doc.getPath().removeLastSegments(1);
                boolean foundParent = false;
                for (DocumentModel d : docs) {
                    if (!d.getPath().equals((Object)path)) continue;
                    foundParent = true;
                }
                if (foundParent) continue;
                childrenNodes.add(new CoreFolderPublicationNode(doc, this.treeConfigName, this.sid, (PublicationNode)this, this.factory));
            }
        }
        return childrenNodes;
    }

    protected CoreSession getCoreSession() {
        return CoreInstance.getInstance().getSession(this.coreSessionId);
    }

    public List<PublishedDocument> getChildrenDocuments() throws ClientException {
        return Collections.emptyList();
    }

    public String getPath() {
        return this.path;
    }

    public String getSessionId() {
        return this.sid;
    }
}

