/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.CachableBlobHolder;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipCachableBlobHolder
extends SimpleCachableBlobHolder
implements CachableBlobHolder {
    protected Blob zipBlob;
    protected MimetypeRegistry mimeTypeService;
    protected String key;

    public ZipCachableBlobHolder() {
    }

    public ZipCachableBlobHolder(Blob zipBlob) {
        this.zipBlob = zipBlob;
    }

    public Blob getBlob(String path) throws IOException, MimetypeNotFoundException, MimetypeDetectionException, ConversionException {
        String filePath = this.key.concat(path);
        File file = new File(filePath);
        FileBlob blob = new FileBlob(file);
        String mimeType = this.getMimeTypeService().getMimetypeFromBlob((Blob)blob);
        blob.setMimeType(mimeType);
        blob.setFilename(path);
        return blob;
    }

    public Blob getBlob() throws ClientException {
        return this.zipBlob;
    }

    public List<Blob> getBlobs() throws ClientException {
        if (this.blobs == null) {
            this.load(this.key);
        }
        return this.blobs;
    }

    public void load(String path) {
        this.blobs = new ArrayList();
        File base = new File(path);
        try {
            if (base.isDirectory()) {
                this.addDirectoryToList(base, "");
            } else {
                File file = new File(path);
                String mimeType = this.getMimeType(file);
                FileBlob mainBlob = new FileBlob(file);
                mainBlob.setMimeType(mimeType);
                mainBlob.setFilename(file.getName());
                this.blobs.add(mainBlob);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Blob loading from cache failed", e.getCause());
        }
    }

    public void addDirectoryToList(File directory, String prefix) throws ConversionException {
        File[] directoryContent;
        for (File file : directoryContent = directory.listFiles()) {
            if (file.isDirectory()) {
                int beginIndex = prefix.length();
                prefix = prefix.concat(file.getName() + File.separatorChar);
                this.addDirectoryToList(file, prefix);
                prefix = prefix.substring(0, beginIndex);
                continue;
            }
            FileBlob blob = new FileBlob(file);
            String mimeType = this.getMimeType(file);
            blob.setMimeType(mimeType);
            blob.setFilename(prefix.concat(file.getName()));
            if (file.getName().equalsIgnoreCase("index.html")) {
                this.blobs.add(0, blob);
                continue;
            }
            this.blobs.add(blob);
        }
    }

    public String persist(String basePath) throws Exception {
        Path path = new Path(basePath);
        path = path.append(this.getHash());
        File dir = new File(path.toString());
        dir.mkdir();
        ZipUtils.unzip((InputStream)this.zipBlob.getStream(), (File)dir);
        this.key = dir.getAbsolutePath();
        return this.key;
    }

    public String getMimeType(File file) throws ConversionException {
        try {
            return this.getMimeTypeService().getMimetypeFromFile(file);
        }
        catch (ConversionException e) {
            throw new ConversionException("Could not get MimeTypeRegistry");
        }
        catch (MimetypeNotFoundException e) {
            return "application/octet-stream";
        }
        catch (MimetypeDetectionException e) {
            return "application/octet-stream";
        }
    }

    public MimetypeRegistry getMimeTypeService() throws ConversionException {
        if (this.mimeTypeService == null) {
            try {
                this.mimeTypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            }
            catch (Exception e) {
                throw new ConversionException("Could not get MimeTypeRegistry");
            }
        }
        return this.mimeTypeService;
    }
}

