/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import com.artofsolving.jodconverter.DefaultDocumentFormatRegistry;
import com.artofsolving.jodconverter.DocumentFamily;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.platform.convert.ooolauncher.OOoConnectionManager;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JODBasedConverter
implements ExternalConverter {
    protected static final String TMP_PATH_PARAMETER = "TmpDirectory";
    private static final Log log = LogFactory.getLog(JODBasedConverter.class);
    private static final DocumentFormatRegistry formatRegistry = new DefaultDocumentFormatRegistry();
    private static final String DEFAULT_OOO_HOST_URL = "localhost";
    private static final int DEFAULT_OOO_HOST_PORT = 8100;
    private static final Lock conLock = new ReentrantLock();
    protected ConverterDescriptor descriptor;

    protected String getDestinationMimeType() {
        return this.descriptor.getDestinationMimeType();
    }

    private DocumentFormat getDestinationFormat() {
        return formatRegistry.getFormatByMimeType(this.getDestinationMimeType());
    }

    private static DocumentFormat getSourceFormat(File file) throws Exception {
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        String mimetypeStr = mimetypeRegistry.getMimetypeFromFile(file);
        DocumentFormat format = mimetypeStr.equals("application/vnd.ms-excel") ? JODBasedConverter.getSourceFormatByExtension("xls") : formatRegistry.getFormatByMimeType(mimetypeStr);
        return format;
    }

    private static DocumentFormat getSourceFormat(String mimetype) {
        return formatRegistry.getFormatByMimeType(mimetype);
    }

    private static DocumentFormat getSourceFormatByExtension(String extension) {
        return formatRegistry.getFormatByFileExtension(extension);
    }

    public String getOOoHostURL() {
        if (this.descriptor.getParameters().containsKey("ooo_host_name")) {
            String host = (String)this.descriptor.getParameters().get("ooo_host_name");
            if (host.trim().startsWith("${")) {
                return DEFAULT_OOO_HOST_URL;
            }
            return host.trim();
        }
        return DEFAULT_OOO_HOST_URL;
    }

    public int getOOoHostPort() {
        if (this.descriptor.getParameters().containsKey("ooo_host_port")) {
            try {
                return Integer.parseInt((String)this.descriptor.getParameters().get("ooo_host_port"));
            }
            catch (NumberFormatException e) {
                return 8100;
            }
        }
        return 8100;
    }

    public OpenOfficeDocumentConverter getOOoDocumentConverter(OpenOfficeConnection connection) throws Exception {
        if (connection != null && connection.isConnected()) {
            return new OpenOfficeDocumentConverter(connection);
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private Boolean adaptFilterNameForHTML2PDF(DocumentFormat sourceFormat, DocumentFormat destinationFormat) {
        if ("text/html".equals(sourceFormat.getMimeType()) && "application/pdf".equals(destinationFormat.getMimeType())) {
            DocumentFamily family = sourceFormat.getFamily();
            destinationFormat.setExportFilter(family, "writer_web_pdf_Export");
            return true;
        }
        return false;
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob inputBlob;
        try {
            inputBlob = blobHolder.getBlob();
        }
        catch (Exception e) {
            log.error((Object)"Error while getting Blob", (Throwable)e);
            throw new ConversionException("Error while getting Blob", e);
        }
        OOoConnectionManager ocm = (OOoConnectionManager)Framework.getLocalService(OOoConnectionManager.class);
        SocketOpenOfficeConnection connection = null;
        if (inputBlob == null) {
            return null;
        }
        String sourceMimetype = inputBlob.getMimeType();
        connection = ocm.getConnection();
        if (connection != null && connection.isConnected()) {
            SimpleCachableBlobHolder simpleCachableBlobHolder;
            File[] files;
            File outFile;
            block25: {
                File sourceFile = null;
                outFile = null;
                files = null;
                try {
                    String ext = inputBlob.getFilename();
                    int dotPosition = ext.lastIndexOf(".");
                    ext = dotPosition == -1 ? ".bin" : ext.substring(dotPosition);
                    sourceFile = File.createTempFile("NXJOOoConverterDocumentIn", ext);
                    InputStream stream = inputBlob.getStream();
                    FileUtils.copyToFile((InputStream)stream, (File)sourceFile);
                    DocumentFormat sourceFormat = null;
                    if (sourceMimetype != null) {
                        sourceFormat = sourceMimetype.equals("application/vnd.ms-excel") ? JODBasedConverter.getSourceFormatByExtension("xls") : JODBasedConverter.getSourceFormat(sourceMimetype);
                    }
                    if (sourceFormat == null) {
                        sourceFormat = JODBasedConverter.getSourceFormat(sourceFile);
                    }
                    DocumentFormat destinationFormat = this.getDestinationFormat();
                    ArrayList<StreamingBlob> blobs = new ArrayList<StreamingBlob>();
                    if (this.descriptor.getDestinationMimeType().equals("text/html")) {
                        String tmpDirPath = this.getTmpDirectory();
                        File myTmpDir = new File(tmpDirPath + "/JODConv_" + System.currentTimeMillis());
                        boolean created = myTmpDir.mkdir();
                        if (!created) {
                            throw new ConversionException("Unable to create temp dir");
                        }
                        outFile = new File(myTmpDir.getAbsolutePath() + "/" + "NXJOOoConverterDocumentOut." + destinationFormat.getFileExtension());
                        created = outFile.createNewFile();
                        if (!created) {
                            throw new ConversionException("Unable to create temp file");
                        }
                        log.debug((Object)"$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$");
                        log.debug((Object)("Input File = " + outFile.getAbsolutePath()));
                        this.getOOoDocumentConverter((OpenOfficeConnection)connection).convert(sourceFile, sourceFormat, outFile, destinationFormat);
                        for (File file : files = myTmpDir.listFiles()) {
                            StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])new FileSource(file).getBytes());
                            if (file.getName().equals(outFile.getName())) {
                                blob.setFilename("index.html");
                                blobs.add(0, blob);
                                continue;
                            }
                            blob.setFilename(file.getName());
                            blobs.add(blob);
                        }
                    } else {
                        this.adaptFilterNameForHTML2PDF(sourceFormat, destinationFormat);
                        outFile = File.createTempFile("NXJOOoConverterDocumentOut", '.' + destinationFormat.getFileExtension());
                        this.getOOoDocumentConverter((OpenOfficeConnection)connection).convert(sourceFile, sourceFormat, outFile, destinationFormat);
                        StreamingBlob blob = StreamingBlob.createFromByteArray((byte[])new FileSource(outFile).getBytes(), (String)this.getDestinationMimeType());
                        blobs.add(blob);
                    }
                    simpleCachableBlobHolder = new SimpleCachableBlobHolder(blobs);
                    Object var25_26 = null;
                    if (connection != null) {
                        ocm.releaseConnection(connection);
                    }
                    if (sourceFile == null) break block25;
                    sourceFile.delete();
                }
                catch (Exception e) {
                    try {
                        log.error((Object)String.format("An error occured trying to convert a file to from %s to %s: %s", sourceMimetype, this.getDestinationMimeType(), e.getMessage()), (Throwable)e);
                        throw new ConversionException("Error in JODConverter", e);
                    }
                    catch (Throwable throwable) {
                        Object var25_27 = null;
                        if (connection != null) {
                            ocm.releaseConnection(connection);
                        }
                        if (sourceFile != null) {
                            sourceFile.delete();
                        }
                        if (outFile != null) {
                            outFile.delete();
                        }
                        if (files != null) {
                            for (void var29_35 : files) {
                                if (!var29_35.exists()) continue;
                                var29_35.delete();
                            }
                        }
                        throw throwable;
                    }
                }
            }
            if (outFile != null) {
                outFile.delete();
            }
            if (files != null) {
                for (void var29_34 : files) {
                    if (!var29_34.exists()) continue;
                    var29_34.delete();
                }
            }
            return simpleCachableBlobHolder;
        }
        throw new ConversionException("Could not connect to the remote OpenOffice server");
    }

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConverterCheckResult isConverterAvailable() {
        SocketOpenOfficeConnection connection;
        OOoConnectionManager ocm;
        block11: {
            block10: {
                ocm = (OOoConnectionManager)Framework.getLocalService(OOoConnectionManager.class);
                connection = null;
                connection = ocm.getConnection();
                if (connection != null) break block10;
                ConverterCheckResult converterCheckResult = new ConverterCheckResult("OOo must be running in Listen mode", "Can not open connection");
                Object var6_7 = null;
                if (connection != null) {
                    ocm.releaseConnection(connection);
                }
                return converterCheckResult;
            }
            this.getOOoDocumentConverter((OpenOfficeConnection)connection);
            if (!connection.isConnected()) break block11;
            ConverterCheckResult converterCheckResult = new ConverterCheckResult();
            Object var6_8 = null;
            if (connection != null) {
                ocm.releaseConnection(connection);
            }
            return converterCheckResult;
        }
        try {
            ConverterCheckResult converterCheckResult = new ConverterCheckResult("OOo must be running in Listen mode", "Can not open connection");
            Object var6_9 = null;
            if (connection != null) {
                ocm.releaseConnection(connection);
            }
            return converterCheckResult;
        }
        catch (Exception e) {
            try {
                ConverterCheckResult converterCheckResult = new ConverterCheckResult("OOo must be running in Listen mode", e.getMessage());
                Object var6_10 = null;
                if (connection != null) {
                    ocm.releaseConnection(connection);
                }
                return converterCheckResult;
            }
            catch (Throwable throwable) {
                block12: {
                    Object var6_11 = null;
                    if (connection == null) break block12;
                    ocm.releaseConnection(connection);
                }
                throw throwable;
            }
        }
    }

    protected String getTmpDirectory() {
        String tmp = null;
        Map parameters = this.descriptor.getParameters();
        if (parameters != null && parameters.containsKey(TMP_PATH_PARAMETER)) {
            tmp = (String)parameters.get(TMP_PATH_PARAMETER);
        }
        if (tmp == null) {
            tmp = System.getProperty("java.io.tmpdir");
        }
        return tmp;
    }
}

