/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.oooserver;

import com.anwrt.ooserver.daemon.Config;
import com.anwrt.ooserver.daemon.Log4JLogger;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.convert.oooserver.ConfigBuilderHelper;
import org.nuxeo.ecm.platform.convert.oooserver.NXOOoServerRunner;
import org.nuxeo.ecm.platform.convert.oooserver.OOoDaemonService;
import org.nuxeo.ecm.platform.convert.oooserver.OOoServerDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class OOoDaemonManagerComponent
extends DefaultComponent
implements OOoDaemonService,
FrameworkListener {
    protected static Thread runner;
    protected static OOoServerDescriptor serverDescriptor;
    protected static Config daemonConfig;
    protected static boolean configured;
    protected static String SERVER_CONFIG_EP;
    protected static int MAX_TRY;
    private static final Log log;
    protected boolean started = false;

    public void deactivate(ComponentContext context) throws Exception {
        if (this.isAvailable() && this.isRunning()) {
            this.stopDaemon();
        }
    }

    public void activate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (SERVER_CONFIG_EP.equals(extensionPoint)) {
            OOoServerDescriptor desc;
            serverDescriptor = desc = (OOoServerDescriptor)contribution;
            Log4JLogger.logInfoAsDebug = desc.getLogInfoAsDebug();
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    protected static Config getOrBuildConfig() {
        ConfigBuilderHelper helper;
        if (daemonConfig == null && (daemonConfig = (helper = new ConfigBuilderHelper(serverDescriptor)).getServerConfig()) != null) {
            configured = true;
        }
        return daemonConfig;
    }

    public boolean isConfigured() {
        if (!configured) {
            OOoDaemonManagerComponent.getOrBuildConfig();
        }
        return configured;
    }

    public boolean isEnabled() {
        return serverDescriptor.isDaemonEnabled();
    }

    protected boolean isAvailable() {
        return this.isEnabled() && this.isConfigured();
    }

    public boolean isRunning() {
        if (!this.isAvailable()) {
            log.error((Object)"Daemon is not available, it can't be running");
            return false;
        }
        if (runner == null || !runner.isAlive()) {
            return false;
        }
        int nbWorkers = this.getNbWorkers();
        return nbWorkers > 0;
    }

    public synchronized int startDaemon() {
        if (!this.isAvailable()) {
            log.error((Object)"Daemon is not available, don't try to start it");
            return -1;
        }
        if (!this.isRunning() && !this.started) {
            log.debug((Object)"Starting new Thread that will handle the Daemon");
            runner = new Thread(new NXOOoServerRunner(OOoDaemonManagerComponent.getOrBuildConfig()));
            runner.setDaemon(true);
            runner.setUncaughtExceptionHandler(new ThreadExceptionHandler());
            runner.start();
            log.debug((Object)"Daemon thread started");
        } else {
            log.debug((Object)"Daemon is already running or is starting");
        }
        this.started = true;
        return 0;
    }

    public synchronized boolean startDaemonAndWaitUntilReady() {
        int start = this.startDaemon();
        if (start < 0) {
            log.error((Object)"Unable to start Daemon thread");
            return false;
        }
        int nbTry = 0;
        if (runner == null) {
            return false;
        }
        while (!this.isRunning()) {
            if (!runner.isAlive()) {
                log.warn((Object)"OOo server Daemon thread exited : check your OOo config");
                return false;
            }
            try {
                Thread.sleep(1000L);
                log.info((Object)"Waiting for Listener to be available ...");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++nbTry <= serverDescriptor.getOooServerStartTimeout()) continue;
            log.info((Object)"Maximum tries reached, kill Daemon thread");
            runner.interrupt();
            return false;
        }
        log.info((Object)"Daemon thread ready to accept connections");
        return true;
    }

    public void stopDaemon() {
        if (!this.isAvailable()) {
            log.error((Object)"No need to stop, Daemon is not Running");
            return;
        }
        this.started = false;
        Config ooServerConfig = OOoDaemonManagerComponent.getOrBuildConfig();
        String urlStop = "uno:" + ooServerConfig.adminAcceptor + ";urp" + ";daemon.stop";
        try {
            XComponentContext initialContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory manager = initialContext.getServiceManager();
            Object unoResolverObj = manager.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", initialContext);
            XUnoUrlResolver unoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)unoResolverObj);
            unoUrlResolver.resolve(urlStop);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean stopDaemonAndWaitForCompletion() {
        if (!this.isAvailable()) {
            log.error((Object)"Daemon is not available, no need to stop it");
            return false;
        }
        this.stopDaemon();
        while (this.isRunning()) {
            try {
                Thread.sleep(400L);
                log.debug((Object)"trying to stop OOo");
            }
            catch (InterruptedException e) {
                log.error((Object)"Error while waiting for Daemon exit", (Throwable)e);
            }
        }
        log.debug((Object)"OOo Daemon stoped");
        return true;
    }

    public int getNbWorkers() {
        if (!this.isAvailable()) {
            log.error((Object)"Daemon is not available, can not get workers");
            return 0;
        }
        if (runner == null || !runner.isAlive()) {
            return 0;
        }
        Config ooServerConfig = OOoDaemonManagerComponent.getOrBuildConfig();
        String urlStatus = "uno:" + ooServerConfig.adminAcceptor + ";urp" + ";daemon.status";
        try {
            XComponentContext initialContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory manager = initialContext.getServiceManager();
            Object unoResolverObj = manager.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", initialContext);
            XUnoUrlResolver unoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)unoResolverObj);
            Object statusObj = unoUrlResolver.resolve(urlStatus);
            XNameAccess status = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)statusObj);
            Object[] workers = (Object[])status.getByName("workers");
            return workers.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
            ClassLoader nuxeoCL = OOoDaemonManagerComponent.class.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(nuxeoCL);
                log.debug((Object)"OOoDaemon Service initialization");
                if (serverDescriptor.isAutoStart()) {
                    if (this.isAvailable()) {
                        log.info((Object)"Starting OOo Daemon");
                        this.startDaemon();
                    } else {
                        log.info((Object)"OOo Server is not well configured, can not start OpenOffice server Daemon");
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(jbossCL);
                log.debug((Object)"JBoss ClassLoader restored");
            }
        }
    }

    static {
        serverDescriptor = new OOoServerDescriptor();
        configured = false;
        SERVER_CONFIG_EP = "oooServerConfig";
        MAX_TRY = 30;
        log = LogFactory.getLog(OOoDaemonManagerComponent.class);
    }

    protected class ThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected ThreadExceptionHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            log.error((Object)"OOo Daemon thread exited", e);
            runner = null;
        }
    }
}

