/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.oooserver;

import com.anwrt.ooserver.daemon.Config;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.convert.oooserver.OOoServerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBuilderHelper {
    private static final Log log = LogFactory.getLog(ConfigBuilderHelper.class);
    private static String UNIX_OO_EXE = "soffice";
    private static String WIN_OO_EXE = "soffice.exe";
    private static String[] UNIX_OO_PATHS = new String[]{"/usr/lib/openoffice/program"};
    private static String[] UNIX_JPIPE_PATHS = new String[]{"/usr/lib/ure/lib"};
    private static String[] MAC_OO_PATHS = new String[]{"/Applications/OpenOffice.org.app/Contents/MacOS"};
    private static String[] MAC_JPIPE_PATHS = new String[]{"/Applications/OpenOffice.org.app/Contents/basis-link/ure-link/lib"};
    private static String[] WIN_OO_PATHS = new String[]{"C:/Program Files/OpenOffice.org 2.2", "C:/Program Files/OpenOffice.org 2.3", "C:/Program Files/OpenOffice.org 2.4", "C:/Program Files/OpenOffice.org 2.5"};
    protected OOoServerDescriptor desc;
    protected String ooCommandPath;
    private Config ooServerConfig;
    protected static String fileSep = System.getProperty("file.separator");

    public ConfigBuilderHelper(OOoServerDescriptor desc) {
        this.desc = desc;
        if (desc.getJpipeLibPath() == null) {
            this.desc.setJpipeLibPath(this.findJlibPipe());
        }
    }

    protected String findJlibPipe() {
        ArrayList<String> possiblePathes = new ArrayList<String>();
        if (ConfigBuilderHelper.isLinux()) {
            possiblePathes.addAll(Arrays.asList(UNIX_JPIPE_PATHS));
        } else if (ConfigBuilderHelper.isMac()) {
            possiblePathes.addAll(Arrays.asList(MAC_JPIPE_PATHS));
        }
        for (String path : possiblePathes) {
            if (!new File(path).exists()) continue;
            return path;
        }
        return null;
    }

    protected static List<String> getSystemPaths() {
        String pathStr = System.getenv("PATH");
        String[] paths = pathStr.split(File.pathSeparator);
        return Arrays.asList(paths);
    }

    protected static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    protected static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.toLowerCase().startsWith("mac os x");
    }

    protected static boolean isLinux() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.toLowerCase().startsWith("linux");
    }

    protected String getOOServerPath() {
        String exeName = UNIX_OO_EXE;
        if (ConfigBuilderHelper.isWindows()) {
            exeName = WIN_OO_EXE;
        }
        if (this.ooCommandPath == null) {
            this.ooCommandPath = this.desc.getOooInstallationPath();
            File oo = new File(this.ooCommandPath + fileSep + exeName);
            if (!oo.exists()) {
                this.ooCommandPath = null;
            }
        }
        if (this.ooCommandPath == null) {
            ArrayList<String> paths = new ArrayList<String>();
            if (ConfigBuilderHelper.isWindows()) {
                paths.addAll(Arrays.asList(WIN_OO_PATHS));
            } else if (ConfigBuilderHelper.isMac()) {
                paths.addAll(Arrays.asList(MAC_OO_PATHS));
            } else {
                paths.addAll(Arrays.asList(UNIX_OO_PATHS));
            }
            paths.addAll(ConfigBuilderHelper.getSystemPaths());
            for (String path : paths) {
                File oo = new File(path + fileSep + exeName);
                if (!oo.exists()) continue;
                this.ooCommandPath = path;
                break;
            }
        }
        return this.ooCommandPath;
    }

    protected ArrayList<String> getUserDirs() {
        ArrayList<String> userDirs = new ArrayList<String>();
        for (int i = 0; i < this.desc.getOooWorkers(); ++i) {
            StringBuffer userDir = new StringBuffer();
            userDir.append("file://");
            userDir.append(System.getProperty("java.io.tmpdir"));
            if (!userDir.toString().endsWith(fileSep)) {
                userDir.append(fileSep);
            }
            userDir.append("nxoosrv");
            userDir.append(i);
            userDirs.add(userDir.toString());
        }
        return userDirs;
    }

    protected static void hackClassLoader(String ldPath) throws IOException {
        try {
            String[] paths;
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            for (String path : paths = (String[])field.get(null)) {
                if (!ldPath.equals(path)) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = ldPath;
            field.set(null, tmp);
            System.setProperty("java.library.path", System.getProperty("java.library.path"));
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    protected String getLibPath() {
        if (this.desc.getJpipeLibPath() != null) {
            return this.desc.getJpipeLibPath();
        }
        return this.getOOServerPath();
    }

    public Config getServerConfig() {
        if (this.ooServerConfig == null) {
            if (this.getOOServerPath() == null) {
                return null;
            }
            this.ooServerConfig = new Config();
            this.ooServerConfig.officeProgramDirectoryPath = this.getOOServerPath();
            this.ooServerConfig.acceptor = "socket,host=" + this.desc.getOooListenerIP() + ",port=" + this.desc.getOooListenerPort();
            this.ooServerConfig.adminAcceptor = "socket,host=" + this.desc.getOooListenerIP() + ",port=" + this.desc.getOooDaemonListenerPort();
            this.ooServerConfig.maxUsageCountPerInstance = this.desc.getOooRecycleInterval();
            this.ooServerConfig.userInstallation = this.getUserDirs();
            log.debug((Object)("OOo config : " + this.ooServerConfig.toString()));
            try {
                String ld_path = this.getLibPath();
                ConfigBuilderHelper.hackClassLoader(ld_path);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.ooServerConfig;
    }
}

