/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.ooolauncher;

import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.platform.convert.ooolauncher.OOoConfigHelper;
import org.nuxeo.ecm.platform.convert.ooolauncher.OOoConnectionManager;
import org.nuxeo.ecm.platform.convert.ooolauncher.OOoLauncherDescriptor;
import org.nuxeo.ecm.platform.convert.ooolauncher.OOoLauncherService;
import org.nuxeo.ecm.platform.convert.oooserver.OOoDaemonManagerComponent;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public class OOoLauncherComponent
extends DefaultComponent
implements OOoLauncherService,
OOoConnectionManager,
FrameworkListener {
    protected static String CONFIG_EP = "oooLauncherConfig";
    protected OOoLauncherDescriptor descriptor = new OOoLauncherDescriptor();
    protected OOoConfigHelper configHelper = null;
    protected Log log = LogFactory.getLog(OOoLauncherComponent.class);
    protected Process OOoProcess = null;
    protected boolean started = false;
    protected int connUsageNb = 0;
    protected static final int maxConnUsage = 50;
    protected boolean failedToConnect = false;
    protected Boolean canGetConnection = null;
    protected SocketOpenOfficeConnection sharedConnection;
    private static final Lock conLock = new ReentrantLock();

    public OOoLauncherDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected OOoConfigHelper getConfigHelper() {
        if (this.configHelper == null) {
            this.configHelper = new OOoConfigHelper(this.descriptor);
        }
        return this.configHelper;
    }

    public boolean isOOoLaunched() {
        return this.started;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIG_EP.equals(extensionPoint)) {
            OOoLauncherDescriptor desc;
            this.descriptor = desc = (OOoLauncherDescriptor)contribution;
        }
    }

    public void activate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.stopOOo();
        File oooDir = new File(OOoConfigHelper.getUserDir());
        if (oooDir.exists()) {
            FileUtils.deleteTree((File)oooDir);
        }
    }

    public boolean waitTillReady() {
        return this.waitTillReady(this.descriptor.getOooStartupTimeOut());
    }

    public Integer getProcessExitCode() {
        int exitCode = 0;
        try {
            exitCode = this.OOoProcess.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
        return exitCode;
    }

    public boolean waitTillReady(int timeOutS) {
        for (int i = 0; i < timeOutS; ++i) {
            if (this.isOOoListening()) {
                return true;
            }
            try {
                Thread.sleep(1000L);
                if (i % 15 != 0) continue;
                this.log.info((Object)"re-try to connect to OOo server");
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Unxpected exception", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isPortFree() {
        boolean bl;
        Socket socket = null;
        try {
            try {
                socket = new Socket();
                InetSocketAddress addr = new InetSocketAddress(this.descriptor.getOooListenerIP(), this.descriptor.getOooListenerPort());
                socket.connect(addr, 100);
                socket.close();
                this.log.debug((Object)"tcp connect succeeded => socket is not free => Ooo is listening ");
                bl = false;
                Object var5_6 = null;
                if (socket == null) return bl;
            }
            catch (Throwable t) {
                this.log.trace((Object)("Error when trying to connect to OOo TCP port " + t.getMessage()));
                this.log.debug((Object)"Stocket seems to be free => ooo is not (yet) listening");
                boolean bl2 = true;
                Object var5_7 = null;
                if (socket == null) return bl2;
                try {
                    socket.close();
                    return bl2;
                }
                catch (IOException e) {
                    this.log.trace((Object)"Error when closing socket", (Throwable)e);
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (socket == null) throw throwable;
            try {}
            catch (IOException e) {
                this.log.trace((Object)"Error when closing socket", (Throwable)e);
                throw throwable;
            }
            socket.close();
            throw throwable;
        }
        try {}
        catch (IOException e) {
            this.log.trace((Object)"Error when closing socket", (Throwable)e);
            return bl;
        }
        socket.close();
        return bl;
    }

    protected SocketOpenOfficeConnection safeGetConnection() {
        OOoConnectorThread thread = new OOoConnectorThread();
        Thread connThread = new Thread(thread);
        connThread.start();
        try {
            connThread.join(3000L);
        }
        catch (InterruptedException e) {
            return null;
        }
        SocketOpenOfficeConnection conn = thread.getConn();
        if (conn == null) {
            this.log.debug((Object)"Killing conn thread");
            connThread.interrupt();
            try {
                connThread.join(1000L);
                this.log.debug((Object)"Conn Thread terminated");
            }
            catch (InterruptedException e) {
                this.log.error((Object)"Error while waiting for connThread to exit");
            }
        }
        return conn;
    }

    public boolean isOOoListening() {
        if (this.isPortFree()) {
            return false;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public boolean startOOoAndWaitTillReady() {
        return this.startOOoAndWaitTillReady(this.descriptor.getOooStartupTimeOut());
    }

    public boolean startOOoAndWaitTillReady(int timeOutS) {
        boolean started = this.startOOo();
        if (!started) {
            return false;
        }
        return this.waitTillReady(timeOutS);
    }

    public boolean startOOo() {
        if (this.started) {
            return true;
        }
        String[] command = this.getConfigHelper().getOOoLaunchCommand();
        try {
            this.OOoProcess = Runtime.getRuntime().exec(command);
            this.started = true;
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to start OOo process", (Throwable)e);
            return false;
        }
        return this.started;
    }

    public boolean stopOooAndWait(int timeOutS) {
        if (!this.isOOoLaunched() || this.OOoProcess == null) {
            this.log.debug((Object)"Can not stop OOo as it is not running (or not started by the launcher)");
            return false;
        }
        boolean stoped = this.stopOOo();
        if (!stoped) {
            this.log.warn((Object)"Unable to kill propertly Ooo process, ... testing if it it still running ...");
        }
        for (int i = 0; i < timeOutS; ++i) {
            if (this.isPortFree()) {
                return true;
            }
            try {
                Thread.sleep(1000L);
                if (i % 15 != 0) continue;
                this.log.info((Object)"Waiting for server to stop accessing connections");
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopOOo() {
        SocketOpenOfficeConnection oooConn;
        block18: {
            if (!this.isOOoLaunched() || this.OOoProcess == null) {
                this.log.debug((Object)"Can not stop OOo as it is not running (or not started by the launcher)");
                return false;
            }
            oooConn = null;
            try {
                if (this.sharedConnection != null && this.sharedConnection.isConnected()) {
                    oooConn = this.sharedConnection;
                    break block18;
                }
                oooConn = new SocketOpenOfficeConnection(this.descriptor.getOooListenerIP(), this.descriptor.getOooListenerPort());
                try {
                    oooConn.connect();
                }
                catch (ConnectException e) {
                    this.log.error((Object)"Unable to connect to Ooo in order to kill it !!!");
                    boolean bl = false;
                    Object var7_8 = null;
                    if (oooConn != null && oooConn.isConnected()) {
                        oooConn.disconnect();
                    }
                    oooConn = null;
                    if (this.sharedConnection != null && this.sharedConnection.isConnected()) {
                        this.sharedConnection.disconnect();
                    }
                    this.sharedConnection = null;
                    this.OOoProcess.destroy();
                    this.started = false;
                    this.OOoProcess = null;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (oooConn != null && oooConn.isConnected()) {
                    oooConn.disconnect();
                }
                oooConn = null;
                if (this.sharedConnection != null && this.sharedConnection.isConnected()) {
                    this.sharedConnection.disconnect();
                }
                this.sharedConnection = null;
                this.OOoProcess.destroy();
                this.started = false;
                this.OOoProcess = null;
                throw throwable;
            }
        }
        try {
            XComponentLoader od = oooConn.getDesktop();
            XComponentContext ctx = oooConn.getComponentContext();
            Object desktopObj = ctx.getServiceManager().createInstanceWithContext("com.sun.star.frame.Desktop", ctx);
            XDesktop desktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktopObj);
            desktop.terminate();
            oooConn.disconnect();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while killing OOo", (Throwable)e);
            boolean bl = false;
            Object var7_9 = null;
            if (oooConn != null && oooConn.isConnected()) {
                oooConn.disconnect();
            }
            oooConn = null;
            if (this.sharedConnection != null && this.sharedConnection.isConnected()) {
                this.sharedConnection.disconnect();
            }
            this.sharedConnection = null;
            this.OOoProcess.destroy();
            this.started = false;
            this.OOoProcess = null;
            return bl;
        }
        Object var7_10 = null;
        if (oooConn != null && oooConn.isConnected()) {
            oooConn.disconnect();
        }
        oooConn = null;
        if (this.sharedConnection != null && this.sharedConnection.isConnected()) {
            this.sharedConnection.disconnect();
        }
        this.sharedConnection = null;
        this.OOoProcess.destroy();
        this.started = false;
        this.OOoProcess = null;
        return true;
    }

    public boolean isAvailable() {
        return this.isConfigured() && this.isPortFree();
    }

    public boolean isEnabled() {
        return this.descriptor.isEnabled() && this.isConfigured();
    }

    public boolean isConfigured() {
        return this.getConfigHelper().isConfiguredOk();
    }

    public boolean canGetConnection() {
        if (this.canGetConnection != null) {
            return this.canGetConnection;
        }
        if (this.failedToConnect) {
            return false;
        }
        if (this.isConfigured()) {
            this.canGetConnection = true;
        } else if (!this.isPortFree()) {
            this.log.info((Object)"Launcher is not enabled, but port is listening, assuming manual startup");
            this.canGetConnection = true;
        } else {
            this.log.warn((Object)"Launcher is not enabled, no OOo instance seems to be listening on the target port");
            this.canGetConnection = false;
        }
        return this.canGetConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireLock() {
        boolean acquired;
        block7: {
            acquired = false;
            try {
                try {
                    acquired = conLock.tryLock(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.log.error((Object)"Cannot acquire an OOo connection");
                    Object var4_3 = null;
                    if (!acquired) {
                        this.log.error((Object)"Cannot acquire an OOo connection :: timeout");
                        return acquired;
                    }
                    this.log.trace((Object)"Acquired connection lock");
                    return acquired;
                }
                Object var4_2 = null;
                if (acquired) break block7;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!acquired) {
                    this.log.error((Object)"Cannot acquire an OOo connection :: timeout");
                    throw throwable;
                }
                this.log.trace((Object)"Acquired connection lock");
                throw throwable;
            }
            this.log.error((Object)"Cannot acquire an OOo connection :: timeout");
            return acquired;
        }
        this.log.trace((Object)"Acquired connection lock");
        return acquired;
    }

    private void releaseLock() {
        conLock.unlock();
        this.log.trace((Object)"Release connection lock");
    }

    public SocketOpenOfficeConnection getConnection() {
        if (!this.canGetConnection()) {
            return null;
        }
        boolean locked = this.acquireLock();
        if (!locked) {
            return null;
        }
        if (this.sharedConnection != null) {
            return this.sharedConnection;
        }
        if (this.isEnabled() && !this.isOOoLaunched()) {
            if (!this.isPortFree()) {
                this.log.info((Object)"OOo port is not free : OOo has been started from outside ?");
            } else {
                this.log.info((Object)"Try to start OOo process");
                boolean ready = this.startOOoAndWaitTillReady();
                if (!ready) {
                    this.log.error((Object)"Unable to start Ooo process");
                    this.failedToConnect = true;
                    return null;
                }
            }
        }
        this.sharedConnection = this.safeGetConnection();
        if (this.sharedConnection == null) {
            this.log.error((Object)"Unable to connect to OOo server");
            this.failedToConnect = true;
            this.releaseLock();
        }
        return this.sharedConnection;
    }

    public void releaseConnection(SocketOpenOfficeConnection connection) {
        this.releaseLock();
        ++this.connUsageNb;
        if (this.connUsageNb > 50) {
            this.sharedConnection.disconnect();
            this.sharedConnection = null;
            this.connUsageNb = 0;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            ClassLoader jbossCL = Thread.currentThread().getContextClassLoader();
            ClassLoader nuxeoCL = OOoDaemonManagerComponent.class.getClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(nuxeoCL);
                this.log.debug((Object)"OOoLauncher Service initialization");
                if (this.descriptor.getStartOOoAtServiceStartup()) {
                    if (this.isConfigured()) {
                        this.log.info((Object)"Starting OOo server process");
                        this.startOOo();
                    } else {
                        this.log.info((Object)"OOo Server is not well configured, can not start OpenOffice server processs");
                    }
                }
                Object var5_4 = null;
                Thread.currentThread().setContextClassLoader(jbossCL);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                Thread.currentThread().setContextClassLoader(jbossCL);
                this.log.debug((Object)"JBoss ClassLoader restored");
                throw throwable;
            }
            this.log.debug((Object)"JBoss ClassLoader restored");
            {
            }
        }
    }

    protected class OOoConnectorThread
    implements Runnable {
        private boolean connectedOk = false;
        protected SocketOpenOfficeConnection conn;

        public OOoConnectorThread() {
            this.conn = new SocketOpenOfficeConnection(OOoLauncherComponent.this.descriptor.getOooListenerIP(), OOoLauncherComponent.this.descriptor.getOooListenerPort());
        }

        public void run() {
            try {
                OOoLauncherComponent.this.log.debug((Object)"Try to connect using SocketOpenOfficeConnection is a separated thread");
                this.conn.connect();
                OOoLauncherComponent.this.log.debug((Object)"SocketOpenOfficeConnection succeeded");
                this.connectedOk = true;
            }
            catch (Exception e) {
                OOoLauncherComponent.this.log.error((Object)"Error while connecting to OOo", (Throwable)e);
                this.conn = null;
            }
        }

        public SocketOpenOfficeConnection getConn() {
            if (this.connectedOk) {
                return this.conn;
            }
            return null;
        }
    }
}

