/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.ooolauncher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.platform.convert.ooolauncher.OOoLauncherDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOoConfigHelper {
    protected OOoLauncherDescriptor desc;
    private static String UNIX_OO_EXE = "soffice";
    private static String WIN_OO_EXE = "soffice.exe";
    private static String[] UNIX_OO_PATHS = new String[]{"/usr/lib/openoffice/program"};
    private static String[] MAC_OO_PATHS = new String[]{"/Applications/OpenOffice.org.app/Contents/MacOS"};
    protected static String fileSep = System.getProperty("file.separator");
    protected String ooCommandPath = null;
    protected static String oooUserPath = null;
    private static String[] WIN_OO_PATHS = new String[]{"C:/Program Files/OpenOffice.org 2.5/program", "C:/Program Files (x86)/OpenOffice.org 2.5/program", "C:/Program Files/OpenOffice.org 3/program", "C:/Program Files (x86)/OpenOffice.org 3/program"};

    public OOoConfigHelper(OOoLauncherDescriptor desc) {
        this.desc = desc;
    }

    protected static List<String> getSystemPaths() {
        String pathStr = System.getenv("PATH");
        String[] paths = pathStr.split(File.pathSeparator);
        return Arrays.asList(paths);
    }

    protected static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    protected static boolean isMac() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.toLowerCase().startsWith("mac os x");
    }

    protected static boolean isLinux() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.toLowerCase().startsWith("linux");
    }

    public boolean isConfiguredOk() {
        return this.getOOoPath() != null;
    }

    public String getOOoPath() {
        String exeName = UNIX_OO_EXE;
        if (OOoConfigHelper.isWindows()) {
            exeName = WIN_OO_EXE;
        }
        if (this.ooCommandPath == null) {
            this.ooCommandPath = this.desc.getOooInstallationPath();
            File oo = new File(this.ooCommandPath + fileSep + exeName);
            if (!oo.exists()) {
                this.ooCommandPath = null;
            }
        }
        if (this.ooCommandPath == null) {
            ArrayList<String> paths = new ArrayList<String>();
            if (OOoConfigHelper.isWindows()) {
                paths.addAll(Arrays.asList(WIN_OO_PATHS));
            } else if (OOoConfigHelper.isMac()) {
                paths.addAll(Arrays.asList(MAC_OO_PATHS));
            } else {
                paths.addAll(Arrays.asList(UNIX_OO_PATHS));
            }
            paths.addAll(OOoConfigHelper.getSystemPaths());
            for (String path : paths) {
                File oo = new File(path + fileSep + exeName);
                if (!oo.exists()) continue;
                this.ooCommandPath = path;
                break;
            }
        }
        if (this.ooCommandPath == null) {
            return null;
        }
        return this.ooCommandPath + fileSep + exeName;
    }

    public String[] getOOoLaunchCommand() {
        String listen = "host=" + this.desc.getOooListenerIP() + ",port=" + this.desc.getOooListenerPort();
        String[] command = new String[]{this.getOOoPath(), "-headless", "-norestore", "-invisible", this.getUserEnvParam(), "-nofirststartwizard", "-accept=socket," + listen + ";urp;StarOffice.Service"};
        return command;
    }

    protected String getUserEnvParam() {
        if (OOoConfigHelper.isWindows()) {
            return "";
        }
        return "-env:UserInstallation=file://" + OOoConfigHelper.getUserDir();
    }

    public static String getUserDir() {
        if (oooUserPath == null) {
            StringBuffer userDir = new StringBuffer();
            userDir.append(System.getProperty("java.io.tmpdir"));
            if (!userDir.toString().endsWith(fileSep)) {
                userDir.append(fileSep);
            }
            userDir.append("nxoosrv-" + System.currentTimeMillis());
            oooUserPath = userDir.toString();
        }
        return oooUserPath;
    }
}

