/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.Config;
import com.anwrt.ooserver.daemon.Logger;
import com.anwrt.ooserver.daemon.OfficeProcess;
import com.anwrt.ooserver.daemon.PoolAdderThread;
import java.util.LinkedList;

public class ProcessPool {
    private LinkedList _list = new LinkedList();
    private OfficeProcess[] _all = null;
    private Config _config = null;

    public OfficeProcess[] getAll() {
        return this._all;
    }

    public ProcessPool(Config config) {
        this._config = config;
    }

    public synchronized void append(OfficeProcess item) {
        if (item == null) {
            Logger.error("Appending null OfficeProcess to the pool");
            return;
        }
        this._list.add(item);
        this.notify();
    }

    public void initializationFinished() {
        Object[] array = this._list.toArray();
        this._all = new OfficeProcess[array.length];
        for (int i = 0; i < array.length; ++i) {
            this._all[i] = (OfficeProcess)array[i];
        }
    }

    public int size() {
        return this._list.size();
    }

    public void terminate() {
        for (int i = 0; i < this._all.length; ++i) {
            this._all[i].terminate();
        }
    }

    public synchronized OfficeProcess pop() {
        OfficeProcess ret = null;
        while (ret == null) {
            if (this._list.size() != 0) {
                ret = (OfficeProcess)this._list.removeFirst();
            } else {
                try {
                    this.wait(this._config.sleepingDelay);
                }
                catch (InterruptedException ex) {
                    Logger.detailedDebug(ex);
                }
            }
            if (ret == null || ret.isResponsive()) continue;
            Logger.info("OfficeProcess died, restarting a new one");
            new PoolAdderThread(this, ret).start();
            this.notify();
            ret = null;
        }
        return ret;
    }

    public void waitTillReady() {
        for (OfficeProcess p : this._list) {
            int t;
            if (p.waitTillReady(new Integer(t = this.size() * this._config.toleratedStartupTimePerInstance))) continue;
            Logger.fatalError("process not ready : " + p);
            return;
        }
    }

    public String getStateString() {
        return "{" + this.size() + "/" + this._config.userInstallation.size() + "}";
    }
}

