/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.Config;
import com.anwrt.ooserver.daemon.Daemon;
import com.anwrt.ooserver.daemon.Logger;
import com.anwrt.ooserver.daemon.OSAbstractLayer;
import com.anwrt.ooserver.daemon.ResponsivenessChecker;
import com.anwrt.ooserver.daemon.TerminateThread;
import com.sun.star.bridge.XBridge;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;

public class OfficeProcess
extends Thread {
    private Config _config;
    private String _userId;
    private Integer _index;
    private Integer _usage = new Integer(0);
    private Long _timestamp = null;
    private XBridge _bridge = null;
    private XComponentContext _context = null;
    private Daemon _daemon;
    private Runtime _runtime = Runtime.getRuntime();
    private Process _process = null;
    private XConnection _connection = null;

    public Long getTimestamp() {
        return this._timestamp;
    }

    public Integer getUsage() {
        return this._usage;
    }

    public String getUserId() {
        return this._userId;
    }

    public Integer getIndex() {
        return this._index;
    }

    public XComponentContext getContext() {
        return this._context;
    }

    public XBridge getBridge() {
        return this._bridge;
    }

    public OfficeProcess(Daemon daemon, String userId, Integer index) {
        this._daemon = daemon;
        this._config = daemon.getConfig();
        this._userId = userId;
        this._index = index;
    }

    private XConnector getNewConnector() throws Exception {
        XComponentContext context = this._daemon.getInitialContext();
        Object connectorObj = context.getServiceManager().createInstanceWithContext("com.sun.star.connection.Connector", context);
        XConnector connector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)connectorObj);
        return connector;
    }

    public void start() {
        String[] command = new String[]{OSAbstractLayer.concatPaths(this._config.officeProgramDirectoryPath, "soffice"), "-env:UserInstallation=" + this._userId, "-headless", "-norestore", "-invisible", "-nofirststartwizard", "-accept=" + this.getConnectString() + ";urp;"};
        try {
            this._process = this._runtime.exec(command);
            if (this._process != null) {
                Logger.info("Worker instance " + this._index + " started : " + this._userId);
            }
        }
        catch (IOException ex) {
            Logger.fatalError("cannot launch OpenOffice Server instance (command=" + command + ") ");
            Logger.debug(ex);
        }
    }

    private void kill() {
        if (this._process != null) {
            this._process.destroy();
            Logger.info(this + " killed");
            this._process = null;
        }
    }

    public void terminate() {
        if (this._context != null) {
            TerminateThread t = new TerminateThread(this._context);
            Logger.info("terminating " + this);
            t.start();
            try {
                t.join(this._config.sleepingDelay);
            }
            catch (InterruptedException ex) {
                Logger.debug(ex);
            }
            if (t.isAlive()) {
                Logger.error(this.toStringDetailed() + " did not react on terminate, killing instance");
                this.kill();
            } else {
                Logger.info(this + " terminated");
            }
            this._context = null;
        }
    }

    public boolean terminateAndRestart() {
        this.terminate();
        try {
            Thread.sleep(this._config.shutdownDelay);
        }
        catch (InterruptedException ex) {
            Logger.debug(ex);
        }
        this._runtime.gc();
        this.start();
        if (!this.waitTillReady(new Integer(this._config.toleratedStartupTimePerInstance))) {
            Logger.error("could not restart instance " + this + ", terminating");
            return false;
        }
        this._usage = new Integer(0);
        return true;
    }

    public boolean tryConnect() {
        try {
            this._connection = this.getNewConnector().connect(this.getConnectString());
            if (this._connection == null) {
                throw new NoConnectException("cannot connect (connector.connect(...) returned null)");
            }
            this._bridge = this._daemon.getBridgeFactory().createBridge("", "urp", this._connection, null);
            if (this._bridge == null) {
                throw new NoConnectException("cannot create bridge from bridge factory");
            }
            Object contextObj = this._bridge.getInstance("StarOffice.ComponentContext");
            this._context = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)contextObj);
            if (this._context == null) {
                throw new NoConnectException("cannot get instance of ComponentContext");
            }
            return this._context != null;
        }
        catch (NoConnectException ex) {
            Logger.debug(this + " not yet responsive : " + (Object)((Object)ex));
            Logger.info("Instance not responsive, retrying to connect soon");
        }
        catch (Exception ex) {
            Logger.error("couldn't connect to OpenOffice instance");
            Logger.debug(ex);
        }
        catch (UnsatisfiedLinkError jniEx) {
            Logger.warning("Unable to access OOo instance, probably wrong UNO JNI lib");
        }
        return false;
    }

    public boolean waitTillReady(Integer timeout) {
        long start = System.currentTimeMillis();
        boolean isTimeout = false;
        while (!this.tryConnect()) {
            if (System.currentTimeMillis() - start > timeout.longValue()) {
                isTimeout = true;
                break;
            }
            try {
                Thread.sleep(this._config.sleepingDelay);
            }
            catch (InterruptedException ex) {}
        }
        if (isTimeout) {
            Logger.error("time-out for process attempting to connect");
            return false;
        }
        return true;
    }

    public void startUsage() {
        this._usage = new Integer(this._usage + 1);
        this._timestamp = new Long(System.currentTimeMillis());
    }

    public long getUsageDuration() {
        return System.currentTimeMillis() - this._timestamp;
    }

    public void endUsage() {
        this._timestamp = null;
    }

    public boolean isResponsive() {
        ResponsivenessChecker rc = new ResponsivenessChecker(this._config, this);
        rc.start();
        return rc.isResponsive();
    }

    public boolean restartWhenNecessary() {
        if (!this.isResponsive()) {
            Logger.info("process " + this + " not responsive anymore, restarting");
            return this.terminateAndRestart();
        }
        if (this._usage >= this._config.calculateMaxUsageCount()) {
            Logger.info("max usage count for instance " + this + " reached, restarting");
            return this.terminateAndRestart();
        }
        return true;
    }

    public String getConnectString() {
        return "pipe,name=daemon-instance-" + this._index;
    }

    public String toString() {
        return "Worker-" + this._index + "(" + this._usage + " uses)";
    }

    public String toStringDetailed() {
        return "<oood.OfficeProcess " + this._userId + ";process=" + this._process + ";connectStr=" + this.getConnectString() + ",usage=" + this._usage + ">";
    }
}

