/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class OSAbstractLayer {
    public static final int OS_UNKNOWN = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_UNIXCOMPATIBLE = 2;
    private int _os = 0;
    private Runtime _runtime;

    public OSAbstractLayer() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        this._os = osName.startsWith("windows") ? 1 : 2;
        this._runtime = Runtime.getRuntime();
    }

    public void kill(String processName) throws IOException {
        switch (this._os) {
            case 1: {
                String[] cmd = new String[]{"tskill", processName};
                Runtime.getRuntime().exec(cmd);
                break;
            }
            case 2: {
                Runtime runtime = Runtime.getRuntime();
                String pid = this.getProcessID(processName);
                if (pid == null) break;
                while (pid != null) {
                    String[] killCmd = new String[]{"/bin/bash", "-c", "kill -9 " + pid};
                    runtime.exec(killCmd);
                    pid = this.getProcessID(processName);
                }
                break;
            }
        }
    }

    private String getProcessID(String processName) throws IOException {
        switch (this._os) {
            case 2: {
                Runtime runtime = Runtime.getRuntime();
                String[] getPidCmd = new String[]{"/bin/bash", "-c", "ps -e|grep " + processName + "|awk '{print $1}'"};
                Process getPidProcess = runtime.exec(getPidCmd);
                InputStreamReader isr = new InputStreamReader(getPidProcess.getInputStream());
                BufferedReader br = new BufferedReader(isr);
                return br.readLine();
            }
        }
        return "";
    }

    public boolean isProcessAlive(int pid) {
        String nullDevice = "0";
        String[] cmd = new String[]{"ps", "-p", "" + pid, ">", nullDevice};
        return true;
    }

    public static String concatPaths(String path1, String path2) {
        char lastChar = path1.charAt(path1.length() - 1);
        String ret = lastChar == '/' || lastChar == '\\' ? path1 + path2 : path1 + File.separator + path2;
        return ret;
    }
}

