/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.IncorrectLoggerLevelException;

public abstract class Logger {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int DEBUG = 4;
    public static final int DETAILED_DEBUG = 5;
    public static final int NB_LEVELS = 6;
    public static final String[] levelStrings = new String[]{"NONE", "ERROR", "INFO", "WARNING", "DEBUG", "DETAILED_DEBUG"};
    protected static int level = 5;
    private static Logger _instance = null;

    public static void newInstance(Logger instance) {
        _instance = instance;
    }

    public static Logger getInstance() {
        return _instance;
    }

    public static void setLevel(int lvl) throws IncorrectLoggerLevelException {
        if (lvl >= 6 || lvl < 0) {
            level = 5;
            throw new IncorrectLoggerLevelException("" + lvl);
        }
        level = lvl;
    }

    public static void setLevel(String lvlStr) throws IncorrectLoggerLevelException {
        String lvl = lvlStr.toUpperCase();
        if (lvl.equals("NONE")) {
            level = 0;
        } else if (lvl.equals("INFO")) {
            level = 2;
        } else if (lvl.equals("WARNING")) {
            level = 3;
        } else if (lvl.equals("ERROR")) {
            level = 1;
        } else if (lvl.equals("DEBUG")) {
            level = 4;
        } else if (lvl.equals("DETAILED_DEBUG")) {
            level = 5;
        } else {
            level = 5;
            throw new IncorrectLoggerLevelException(lvl);
        }
    }

    public String levelToString() {
        return levelStrings[level];
    }

    public static int getLevel() {
        return level;
    }

    protected abstract void infoImpl(String var1);

    public static void info(String msg) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 2) {
            Logger.getInstance().infoImpl(msg);
        }
    }

    protected abstract void warningImpl(String var1);

    public static void warning(String msg) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 3) {
            Logger.getInstance().warningImpl(msg);
        }
    }

    protected abstract void debugImpl(String var1);

    public static void debug(String msg) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 4) {
            Logger.getInstance().debugImpl(msg);
        }
    }

    protected abstract void debugImpl(String var1, Exception var2);

    public static void debug(String msg, Exception ex) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 4) {
            Logger.getInstance().debugImpl(msg, ex);
        }
    }

    protected abstract void debugImpl(Exception var1);

    public static void debug(Exception ex) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 4) {
            Logger.getInstance().debugImpl(ex);
        }
    }

    protected abstract void detailedDebugImpl(Exception var1);

    public static void detailedDebug(Exception ex) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 5) {
            Logger.getInstance().detailedDebugImpl(ex);
        }
    }

    protected abstract void errorImpl(String var1);

    public static void error(String msg) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 1) {
            Logger.getInstance().errorImpl(msg);
        }
    }

    protected abstract void fatalErrorImpl(String var1);

    public static void fatalError(String msg) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 1) {
            Logger.getInstance().fatalErrorImpl(msg);
        }
    }

    protected abstract void fatalErrorImpl(String var1, Exception var2);

    public static void fatalError(String msg, Exception ex) {
        if (Logger.getInstance() == null) {
            return;
        }
        if (level >= 1) {
            Logger.getInstance().fatalErrorImpl(msg, ex);
        }
    }

    public String toString() {
        return "Logger[level=" + this.levelToString() + "]";
    }

    public static String levelInformation(String prefixTabs) {
        if (prefixTabs == null) {
            prefixTabs = "";
        }
        String ret = prefixTabs + "NONE           : " + "no output, nothing, nada\n" + prefixTabs + "ERROR          : " + "only errors and fatal errors will be displayed \n" + prefixTabs + "                 " + "(stack traces not available)\n" + prefixTabs + "INFO           : " + "informations about the execution process will be displayed\n" + prefixTabs + "WARNING        : " + "warnings displayed added to previous level informations\n" + prefixTabs + "DEBUG          : " + "debug information ( + exceptions stack traces )\n" + prefixTabs + "DETAILED_DEBUG : " + "debug + minor informations \n " + prefixTabs + "                 " + "(exceptions during tries, sleep, etc...)\n";
        return ret;
    }
}

