/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.AdminAcceptorThread;
import com.anwrt.ooserver.daemon.CommandLine;
import com.anwrt.ooserver.daemon.Config;
import com.anwrt.ooserver.daemon.ConfigHandler;
import com.anwrt.ooserver.daemon.ConnectionListener;
import com.anwrt.ooserver.daemon.EmptyPoolInstanceProvider;
import com.anwrt.ooserver.daemon.Logger;
import com.anwrt.ooserver.daemon.OfficeInstanceProvider;
import com.anwrt.ooserver.daemon.OfficeProcess;
import com.anwrt.ooserver.daemon.ProcessPool;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.Timer;

public class Daemon {
    public static final float VERSION = 1.0f;
    public static final String VERSION_TYPE = "beta";
    private XComponentContext _initialContext = null;
    private Config _config = null;
    private ProcessPool _processPool = null;
    private Timer _shutdownThread = null;
    private XAcceptor _acceptor = null;
    private XBridgeFactory _bridgeFactory = null;
    private AdminAcceptorThread _adminThread = null;
    private boolean _isShutdowned = false;

    public static String getVersionString() {
        return "1.0 beta";
    }

    public ProcessPool getPool() {
        return this._processPool;
    }

    public XComponentContext getInitialContext() {
        return this._initialContext;
    }

    public XBridgeFactory getBridgeFactory() {
        return this._bridgeFactory;
    }

    public Config getConfig() {
        return this._config;
    }

    public synchronized boolean isShutdowned() {
        return this._isShutdowned;
    }

    public Daemon(Config config) {
        this._config = config;
        this.init();
    }

    public Daemon(String configPath) {
        try {
            ConfigHandler configHandler = new ConfigHandler();
            System.out.println("read configuration");
            this._config = configHandler.readConfiguration(configPath);
            System.out.println("read configuration ok");
        }
        catch (Exception ex) {
            Logger.fatalError("Cannot read configuration", ex);
            return;
        }
        this.init();
    }

    private void init() {
        try {
            Logger.info("init starting ...");
            this.initConfig();
            this.initOOAPI();
            Logger.info("init OK");
        }
        catch (Exception ex) {
            Logger.fatalError("Cannot init OpenOffice daemon", ex);
        }
    }

    private void initConfig() throws Exception {
        if (this._config == null) {
            throw new Exception("no configuration specified");
        }
        this._config.validate();
        Logger.info("\n" + this._config);
    }

    private void initOOAPI() throws Exception {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this._initialContext = Bootstrap.createInitialComponentContext(null);
        XMultiComponentFactory manager = this._initialContext.getServiceManager();
        this._processPool = new ProcessPool(this._config);
        this._shutdownThread = null;
        Object acceptorObj = manager.createInstanceWithContext("com.sun.star.connection.Acceptor", this._initialContext);
        this._acceptor = (XAcceptor)UnoRuntime.queryInterface(XAcceptor.class, (Object)acceptorObj);
        Object bridgeFactoryObj = manager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", this._initialContext);
        this._bridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)bridgeFactoryObj);
    }

    public synchronized void shutdown() {
        this._isShutdowned = true;
        try {
            if (this._acceptor != null) {
                this._acceptor.stopAccepting();
            }
            this._processPool.terminate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.logBigMessage("OPEN OFFICE DAEMON STOPPED");
    }

    public static String extractContactInfo(String namevalue) {
        String[] list = namevalue.split(",");
        String host = "";
        String port = "";
        for (int i = 0; i < list.length; ++i) {
            String str = list[i];
            if (str.startsWith("peerHost")) {
                host = str.split("=")[1];
                continue;
            }
            if (!str.startsWith("peerPort")) continue;
            port = str.split("=")[1];
        }
        return host + ":" + port;
    }

    private void createBridgeWithEmptyPoolInstanceProvider(XConnection connection, String connectionDesc) {
        Logger.error(this._processPool.getStateString() + " " + connectionDesc + " rejected, all workers are busy");
        try {
            this._bridgeFactory.createBridge("", "urp", connection, (XInstanceProvider)new EmptyPoolInstanceProvider());
        }
        catch (BridgeExistsException ex) {
            Logger.error("Bridge already exists, cannot create new one");
            Logger.debug((Exception)((Object)ex));
        }
        catch (IllegalArgumentException ex) {
            Logger.error("Illegal argument for bridge creation");
            Logger.debug((Exception)((Object)ex));
        }
    }

    private void createBridgeWithOfficeInstanceProvider(XConnection connection, OfficeProcess process, String connectionDesc) {
        process.startUsage();
        Logger.info(this._processPool.getStateString() + " -> " + process + " serves " + connectionDesc);
        XConnectionBroadcaster xConnectionBroadcaster = (XConnectionBroadcaster)UnoRuntime.queryInterface(XConnectionBroadcaster.class, (Object)connection);
        xConnectionBroadcaster.addStreamListener((XStreamListener)new ConnectionListener(this._processPool, process, connectionDesc));
        try {
            this._bridgeFactory.createBridge("", "urp", connection, (XInstanceProvider)new OfficeInstanceProvider(process));
        }
        catch (BridgeExistsException ex) {
            Logger.error("Bridge already exists, cannot create new one");
            Logger.debug((Exception)((Object)ex));
        }
        catch (IllegalArgumentException ex) {
            Logger.error("Illegal argument for bridge creation");
            Logger.debug((Exception)((Object)ex));
        }
    }

    private void mainLoop() {
        while (true) {
            XConnection connection = null;
            try {
                connection = this._acceptor.accept(this._config.acceptor);
            }
            catch (ConnectionSetupException ex) {
                if (this.isShutdowned()) break;
                Logger.error("Connection setup exception when trying to accept new connection");
                Logger.debug((Exception)((Object)ex));
            }
            catch (AlreadyAcceptingException ex) {
                Logger.error("Already accepting connection, cannot connect");
                Logger.debug((Exception)((Object)ex));
            }
            catch (IllegalArgumentException ex) {
                Logger.error("Illegal argument for connection accepting");
                Logger.debug((Exception)((Object)ex));
            }
            catch (Throwable t) {
                Logger.error("main thread exited " + t.getMessage());
            }
            if (connection == null) break;
            String connectionDesc = Daemon.extractContactInfo(connection.getDescription());
            Logger.info("Incoming request for a worker from " + connectionDesc);
            Logger.debug("process pool size : " + this._processPool.size());
            OfficeProcess process = this._processPool.pop();
            if (process == null) {
                this.createBridgeWithEmptyPoolInstanceProvider(connection, connectionDesc);
                continue;
            }
            this.createBridgeWithOfficeInstanceProvider(connection, process, connectionDesc);
        }
    }

    public void fillProcessPool() {
        int index = 0;
        for (String userId : this._config.userInstallation) {
            OfficeProcess p = new OfficeProcess(this, userId, new Integer(index));
            p.start();
            this._processPool.append(p);
            ++index;
        }
        this._processPool.waitTillReady();
        this._processPool.initializationFinished();
        if (this._config.adminNeeded()) {
            this._adminThread = new AdminAcceptorThread(this, this._shutdownThread, this._config.adminAcceptor);
            this._adminThread.start();
        }
        Logger.info(this._processPool.getStateString() + " All worker instances started");
    }

    public void run() {
        this.fillProcessPool();
        Logger.info("Accepting on " + this._config.acceptor);
        this.logBigMessage("OPEN OFFICE DAEMON STARTED");
        this.mainLoop();
        this.terminate();
    }

    private void terminate() {
        Logger.info("Accepting on " + this._config.acceptor + " stopped, waiting for shutdownthread");
        if (this._adminThread != null) {
            this._adminThread.cancel();
        }
        try {
            if (this._shutdownThread != null) {
                this._shutdownThread.cancel();
            }
        }
        catch (Exception ex) {
            Logger.debug(ex);
        }
        try {
            if (this._adminThread != null) {
                this._adminThread.join();
            }
        }
        catch (Exception ex) {
            Logger.debug(ex);
        }
        Logger.info("Terminating normally");
    }

    private void logBigMessage(String msg) {
        String line = "======================================\n\n";
        String str = "\n======================================\n\n    " + msg + "\n\n" + "======================================\n\n";
        Logger.info(str);
    }

    public static void main(String[] args) {
        CommandLine.start(args);
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        public void run() {
            Daemon.this.shutdown();
        }
    }
}

