/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import java.io.File;
import java.util.ArrayList;

public class Config {
    public String adminAcceptor = null;
    public String acceptor = null;
    public String officeProgramDirectoryPath = "./program/";
    public ArrayList userInstallation = new ArrayList();
    public int toleratedStartupTimePerInstance = 180000;
    public int maxUsageCountPerInstance = 30;
    public int randomUsageCountPerInstance = 3;
    public int sleepingDelay = 4000;
    public int shutdownDelay = 1000;
    public boolean exitsWhenInstanceCannotBeCreated = true;
    public static final String CONFIG_TAG = "config : ";

    public boolean adminNeeded() {
        return this.adminAcceptor != null;
    }

    public int calculateMaxUsageCount() {
        return (int)Math.round((double)this.maxUsageCountPerInstance + (1.0 - 2.0 * Math.random()) * (double)this.randomUsageCountPerInstance);
    }

    public int convertMillisToSeconds(int millis) {
        return (int)Math.round((double)millis * 0.001);
    }

    public void validate() throws Exception {
        if (this.userInstallation.isEmpty()) {
            throw new Exception("config : no user installation found");
        }
        if (this.acceptor == null || this.acceptor.equals("")) {
            throw new Exception("config : acceptor is empty");
        }
        File tmp = new File(this.officeProgramDirectoryPath);
        if (!tmp.canRead()) {
            throw new Exception("config : office program directory path (" + this.officeProgramDirectoryPath + ") does not exist or is not readable");
        }
    }

    public String toString() {
        String str = "<CONFIGURATION>\n\tadminAcceptor                       : " + this.adminAcceptor + "\n" + "\tacceptor                            : " + this.acceptor + "\n" + "\toffice program directory path       : " + this.officeProgramDirectoryPath + "\n";
        for (int i = 0; i < this.userInstallation.size(); ++i) {
            str = str + "\tuser installation                   : " + this.userInstallation.get(i) + "\n";
        }
        str = str + "\ttolerated startup time per instance : " + this.convertMillisToSeconds(this.toleratedStartupTimePerInstance) + "\n" + "\tmax usage count per instance        : " + this.maxUsageCountPerInstance + "\n" + "\trandom usage count per instance     : " + this.randomUsageCountPerInstance + "\n" + "\tsleeping delay                      : " + this.convertMillisToSeconds(this.sleepingDelay) + "\n" + "\tshutdown delay                      : " + this.convertMillisToSeconds(this.shutdownDelay) + "\n" + "</CONFIGURATION>\n";
        return str;
    }
}

