/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.TypeManager;

public class NoteImporter
extends AbstractFileImporter {
    private static final String ICON_FIELD = "icon";
    private static final String COMMON_SCHEMA = "common";
    private static final String NOTE_FIELD = "note";
    private static final String MT_FIELD = "mime_type";
    private static final String NOTE_SCHEMA = "note";
    private static final String TITLE_FIELD = "title";
    private static final String DUBLINCORE_SCHEMA = "dublincore";
    private static final String NOTE_TYPE = "Note";
    private static final long serialVersionUID = 1073550562485540108L;
    private static final Log log = LogFactory.getLog(NoteImporter.class);

    protected String getNoteTypeName() {
        return NOTE_TYPE;
    }

    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        path = this.getNearestContainerPath(documentManager, path);
        this.doSecurityCheck(documentManager, path, this.getNoteTypeName(), typeService);
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        String title = FileManagerUtils.fetchTitle((String)filename);
        DocumentModel docModel = FileManagerUtils.getExistingDocByTitle((CoreSession)documentManager, (String)path, (String)title);
        if (overwrite && docModel != null) {
            docModel.setProperty("note", "note", (Object)content.getString());
            docModel = this.overwriteAndIncrementversion(documentManager, docModel);
        } else {
            String docId = IdUtils.generateId((String)title);
            docModel = documentManager.createDocumentModel(path, docId, this.getNoteTypeName());
            docModel.setProperty(DUBLINCORE_SCHEMA, TITLE_FIELD, (Object)title);
            docModel.setProperty("note", "note", (Object)content.getString());
            String mt = "text/plain";
            String extension = new Path(filename).getFileExtension().toLowerCase();
            if (extension.endsWith("htm") || extension.endsWith("html")) {
                mt = "text/html";
            } else if (extension.endsWith("xml")) {
                mt = "text/xml";
            }
            docModel.setProperty("note", MT_FIELD, (Object)mt);
            docModel = documentManager.createDocument(docModel);
        }
        documentManager.save();
        log.debug((Object)("Created the Note: " + docModel.getName() + " with icon: " + docModel.getProperty(COMMON_SCHEMA, ICON_FIELD)));
        return docModel;
    }
}

