/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.TypeManager;

public class DefaultFileImporter
extends AbstractFileImporter {
    public static final String TYPE_NAME = "File";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DefaultFileImporter.class);

    public String getTypeName() {
        return TYPE_NAME;
    }

    public DocumentModel create(CoreSession documentManager, Blob input, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        path = this.getNearestContainerPath(documentManager, path);
        String typeName = this.getTypeName();
        this.doSecurityCheck(documentManager, path, typeName, typeService);
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        input.setFilename(filename);
        DocumentModel docModel = FileManagerUtils.getExistingDocByFileName((CoreSession)documentManager, (String)path, (String)filename);
        if (overwrite && docModel != null) {
            documentManager.saveDocument(docModel);
            documentManager.save();
            docModel.setProperty("file", "content", (Object)input);
            docModel = this.overwriteAndIncrementversion(documentManager, docModel);
        } else {
            String title = FileManagerUtils.fetchTitle((String)filename);
            String docId = IdUtils.generateId((String)title);
            docModel = documentManager.createDocumentModel(path, docId, typeName);
            docModel.setProperty("dublincore", "title", (Object)title);
            docModel.setProperty("file", "filename", (Object)filename);
            docModel.setProperty("file", "content", (Object)input);
            docModel = documentManager.createDocument(docModel);
        }
        documentManager.save();
        log.debug((Object)("imported the document: " + docModel.getName() + " with icon: " + docModel.getProperty("common", "icon") + " and type: " + typeName));
        return docModel;
    }
}

