/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.server.jaxrs.RestOperationContext;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionRequest {
    protected Object input;
    protected RestOperationContext ctx = new RestOperationContext();
    protected Map<String, Object> params;

    public ExecutionRequest(Object input) {
        this.input = input;
        this.params = new HashMap<String, Object>();
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public void setContextParam(String key, String value) {
        this.ctx.put(key, value);
    }

    public void setParam(String key, String value) {
        if (value.startsWith("expr:")) {
            if ((value = value.substring(5).trim()).indexOf("@{") > -1) {
                this.params.put(key, Scripting.newTemplate((String)value));
            } else {
                this.params.put(key, Scripting.newExpression((String)value));
            }
        } else {
            this.params.put(key, value);
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public OperationContext createContext(HttpServletRequest request, CoreSession session) throws Exception {
        this.ctx.addRequestCleanupHandler(request);
        this.ctx.setCoreSession(session);
        this.ctx.setInput(ExecutionRequest.decodeInput(session, this.input));
        return this.ctx;
    }

    public OperationChain createChain(OperationType op) {
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters(op.getId(), this.params);
        chain.add(oparams);
        return chain;
    }

    public static Object decodeInput(CoreSession session, Object input) throws Exception {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            String inputS = input.toString();
            if (inputS.startsWith("/")) {
                return session.getDocument((DocumentRef)new PathRef(inputS));
            }
            return session.getDocument((DocumentRef)new IdRef(inputS));
        }
        return input;
    }
}

