/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.api.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetImpl
implements Widget {
    private static final long serialVersionUID = -2954101230598440812L;
    protected String id;
    protected final String layoutName;
    protected final String name;
    protected final String mode;
    protected final String type;
    protected final FieldDefinition[] fields;
    protected final String helpLabel;
    protected final Widget[] subWidgets;
    protected Map<String, Serializable> properties;
    protected final boolean required;
    protected String valueName;
    protected String label;
    protected boolean translated = false;
    protected int level;

    public WidgetImpl(String layoutName, String name, String mode, String type, String valueName, FieldDefinition[] fields, String label, String helpLabel, boolean translated, Map<String, Serializable> properties, boolean required, Widget[] subWidgets, int level) {
        this.layoutName = layoutName;
        this.name = name;
        this.mode = mode;
        this.type = type;
        this.valueName = valueName;
        this.fields = fields;
        this.label = label;
        this.helpLabel = helpLabel;
        this.translated = translated;
        this.properties = properties;
        this.required = required;
        this.subWidgets = subWidgets;
        this.level = level;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getLayoutName() {
        return this.layoutName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            this.label = String.format("label.widget.%s.%s", this.layoutName, this.name);
        }
        return this.label;
    }

    @Override
    public String getHelpLabel() {
        return this.helpLabel;
    }

    @Override
    public boolean isTranslated() {
        return this.translated;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Serializable getProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public void setProperty(String name, Serializable value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>();
        }
        this.properties.put(name, value);
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public FieldDefinition[] getFieldDefinitions() {
        return this.fields;
    }

    @Override
    public Widget[] getSubWidgets() {
        return this.subWidgets;
    }

    @Override
    public String getValueName() {
        return this.valueName;
    }

    @Override
    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    @Override
    public int getLevel() {
        return this.level;
    }
}

