/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.util;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.jboss.remoting.util.StoppableTimerTask;

public class TimerUtil {
    private static Timer timer = null;
    private static ArrayList stoppableTasks = new ArrayList();
    private static Logger log = Logger.getLogger(TimerUtil.class);

    private static synchronized void init() {
        timer = new Timer(true);
    }

    public static synchronized void schedule(TimerTask task, long period) {
        if (timer == null) {
            TimerUtil.init();
        }
        if (task instanceof StoppableTimerTask) {
            stoppableTasks.add(task);
        }
        timer.schedule(task, period, period);
    }

    public static synchronized void unschedule(TimerTask task) {
        if (!(task instanceof StoppableTimerTask)) {
            log.warn((Object)"TimerUtil only remembers StoppableTimerTasks");
            return;
        }
        StoppableTimerTask stoppableTask = (StoppableTimerTask)((Object)task);
        if (!stoppableTasks.remove(stoppableTask)) {
            log.warn((Object)("unrecognized StoppableTimerTask: " + task));
        }
        try {
            stoppableTask.stop();
        }
        catch (Exception e) {
            log.warn((Object)("error calling stop() on: " + stoppableTask), (Throwable)e);
        }
    }

    public static synchronized void destroy() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        for (StoppableTimerTask task : new ArrayList(stoppableTasks)) {
            try {
                task.stop();
            }
            catch (Exception e) {
                log.warn((Object)("unable to stop TimerTask: " + task));
            }
        }
    }
}

