/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexBuilder;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import java.io.File;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class IndexBuilderBase
implements IndexBuilder {
    private Directory dir = null;
    private IndexWriter indexWriter = null;
    private IndexReader indexReader = null;
    private boolean isClosed;

    public IndexBuilderBase() {
        this.dir = new RAMDirectory();
        this.makeIndex();
    }

    public IndexBuilderBase(IndexWriter existingWriter) {
        this.dir = existingWriter.getDirectory();
        this.indexWriter = existingWriter;
    }

    public IndexBuilderBase(File fileDir) {
        try {
            this.dir = FSDirectory.getDirectory((File)fileDir, (boolean)true);
            this.makeIndex();
        }
        catch (Exception ex) {
            throw new ARQLuceneException("IndexBuilderLARQ", ex);
        }
    }

    public IndexBuilderBase(String fileDir) {
        try {
            this.dir = FSDirectory.getDirectory((String)fileDir, (boolean)true);
            this.makeIndex();
        }
        catch (Exception ex) {
            throw new ARQLuceneException("IndexBuilderLARQ", ex);
        }
    }

    private void makeIndex() {
        try {
            this.indexWriter = new IndexWriter(this.dir, (Analyzer)new StandardAnalyzer(), true);
            this.isClosed = false;
        }
        catch (Exception ex) {
            throw new ARQLuceneException("IndexBuilderLARQ", ex);
        }
    }

    protected IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    protected IndexReader getIndexReader() {
        if (this.indexReader == null) {
            try {
                if (!this.isClosed) {
                    this.closeForWriting();
                }
                this.indexReader = IndexReader.open((Directory)this.dir);
            }
            catch (Exception e2) {
                throw new ARQLuceneException("getIndexReader", e2);
            }
        }
        return this.indexReader;
    }

    public void closeForWriting() {
        this.closeForWriting(true);
    }

    public void closeForWriting(boolean optimize) {
        try {
            if (!this.isClosed && this.indexWriter != null) {
                if (optimize) {
                    this.indexWriter.optimize();
                }
                this.indexWriter.close();
            }
            this.isClosed = true;
        }
        catch (Exception e2) {
            throw new ARQLuceneException("close", e2);
        }
    }

    public IndexLARQ getIndex() {
        this.closeForWriting();
        return new IndexLARQ(this.getIndexReader());
    }
}

