/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.Serializable;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="suggestionActions")
@Scope(value=ScopeType.EVENT)
public class SuggestionActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SuggestionActionsBean.class);
    @RequestParameter
    protected String suggestionInputSelectorId;
    @RequestParameter
    protected String suggestionSelectionListId;
    @RequestParameter
    protected String suggestionSelectionOutputId;
    @RequestParameter
    protected String suggestionSelectionHiddenId;
    @RequestParameter
    protected String suggestionSelectionDeleteId;
    protected String selectedValue;

    public String getSelectedValue() {
        return this.selectedValue;
    }

    public void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    @Deprecated
    protected UIComponent getBase(UIComponent anchor) {
        return ComponentUtils.getBase(anchor);
    }

    protected <T> T getComponent(UIComponent base, String componentId, Class<T> expectedComponentClass) {
        block6: {
            if (componentId == null) {
                log.error((Object)"Cannot retrieve component with a null id");
                return null;
            }
            try {
                UIComponent component = base.findComponent(componentId);
                if (component == null) {
                    log.error((Object)("Could not find component with id: " + componentId));
                    break block6;
                }
                try {
                    return (T)component;
                }
                catch (ClassCastException e) {
                    log.error((Object)String.format("Invalid component with id %s: %s, expected a component with interface %s", componentId, component, expectedComponentClass));
                }
            }
            catch (Exception e) {
                log.error((Object)("Error when trying to retrieve component with id " + componentId), (Throwable)e);
            }
        }
        return null;
    }

    public void addBoundSelectionToList(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent base = ComponentUtils.getBase(component);
        UIEditableList list = this.getComponent(base, this.suggestionSelectionListId, UIEditableList.class);
        if (list != null) {
            String selectedValue = this.getSelectedValue();
            list.addValue(selectedValue);
        }
    }

    @Deprecated
    public void addSelectionToList(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent base = ComponentUtils.getBase(component);
        ValueHolder selector = this.getComponent(base, this.suggestionInputSelectorId, ValueHolder.class);
        UIEditableList list = this.getComponent(base, this.suggestionSelectionListId, UIEditableList.class);
        if (selector != null && list != null) {
            list.addValue(selector.getValue());
        }
    }

    public void addSingleBoundSelection(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent base = ComponentUtils.getBase(component);
        EditableValueHolder hiddenSelector = this.getComponent(base, this.suggestionSelectionHiddenId, EditableValueHolder.class);
        ValueHolder output = this.getComponent(base, this.suggestionSelectionOutputId, ValueHolder.class);
        if (hiddenSelector != null && output != null) {
            UIComponent deleteComponent;
            String selectedValue = this.getSelectedValue();
            output.setValue((Object)selectedValue);
            hiddenSelector.setSubmittedValue((Object)selectedValue);
            if (this.suggestionSelectionDeleteId != null && (deleteComponent = this.getComponent(base, this.suggestionSelectionDeleteId, UIComponent.class)) != null) {
                deleteComponent.setRendered(true);
            }
        }
    }

    @Deprecated
    public void addSingleSelection(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent base = ComponentUtils.getBase(component);
        ValueHolder selector = this.getComponent(base, this.suggestionInputSelectorId, ValueHolder.class);
        EditableValueHolder hiddenSelector = this.getComponent(base, this.suggestionSelectionHiddenId, EditableValueHolder.class);
        ValueHolder output = this.getComponent(base, this.suggestionSelectionOutputId, ValueHolder.class);
        if (selector != null && hiddenSelector != null && output != null) {
            UIComponent deleteComponent;
            String selection = (String)selector.getValue();
            output.setValue((Object)selection);
            hiddenSelector.setSubmittedValue((Object)selection);
            if (this.suggestionSelectionDeleteId != null && (deleteComponent = this.getComponent(base, this.suggestionSelectionDeleteId, UIComponent.class)) != null) {
                deleteComponent.setRendered(true);
            }
        }
    }

    public void clearSingleSelection(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent base = component;
        EditableValueHolder hiddenSelector = this.getComponent(base, this.suggestionSelectionHiddenId, EditableValueHolder.class);
        ValueHolder output = this.getComponent(base, this.suggestionSelectionOutputId, ValueHolder.class);
        if (hiddenSelector != null && output != null) {
            UIComponent deleteComponent;
            output.setValue((Object)"");
            hiddenSelector.setSubmittedValue((Object)"");
            if (this.suggestionSelectionDeleteId != null && (deleteComponent = this.getComponent(base, this.suggestionSelectionDeleteId, UIComponent.class)) != null) {
                deleteComponent.setRendered(false);
            }
        }
    }
}

