/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="uploadFileRestlet")
@Scope(value=ScopeType.EVENT)
public class UploadFileRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    private static final long serialVersionUID = -6167207806181917456L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected CoreSession documentManager;

    public void handle(Request req, Response res) {
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String filename = (String)req.getAttributes().get("filename");
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            UploadFileRestlet.handleError(res, e);
            return;
        }
        if (repo == null || repo.equals("*")) {
            UploadFileRestlet.handleError(res, "you must specify a repository");
            return;
        }
        DocumentModel dm = null;
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            if (docid != null) {
                dm = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
            }
        }
        catch (ClientException e) {
            UploadFileRestlet.handleError(res, (Exception)((Object)e));
            return;
        }
        try {
            Blob blob = StreamingBlob.createFromStream((InputStream)req.getEntity().getStream()).persist();
            blob.setFilename(filename);
            String blobPropertyName = UploadFileRestlet.getQueryParamValue(req, "blobPropertyName", null);
            String filenamePropertyName = UploadFileRestlet.getQueryParamValue(req, "filenamePropertyName", null);
            if (blobPropertyName != null && filenamePropertyName != null) {
                dm.setPropertyValue(blobPropertyName, (Serializable)blob);
                dm.setPropertyValue(filenamePropertyName, (Serializable)((Object)filename));
            } else {
                String schemaName = UploadFileRestlet.getQueryParamValue(req, "schema", "file");
                String blobFieldName = UploadFileRestlet.getQueryParamValue(req, "blobField", "content");
                String filenameFieldName = UploadFileRestlet.getQueryParamValue(req, "filenameField", "filename");
                dm.setProperty(schemaName, blobFieldName, (Object)blob);
                dm.setProperty(schemaName, filenameFieldName, (Object)filename);
            }
            this.documentManager.saveDocument(dm);
            this.documentManager.save();
        }
        catch (Exception e) {
            UploadFileRestlet.handleError(res, e);
        }
    }
}

