/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.restlet.Filter;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class ThreadSafeRestletFilter
extends Filter {
    private static final Log log = LogFactory.getLog(ThreadSafeRestletFilter.class);

    protected void beforeHandle(Request request, Response response) {
    }

    protected void afterHandle(Request request, Response response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doHandle(Request request, Response response) {
        if (this.getNext() == null) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return;
        }
        boolean started = false;
        try {
            try {
                Restlet next = (Restlet)this.getNext().getClass().newInstance();
                started = TransactionHelper.startTransaction();
                next.handle(request, response);
            }
            catch (Exception e) {
                log.error((Object)"Restlet handling error", (Throwable)e);
                TransactionHelper.setTransactionRollbackOnly();
                response.setEntity("Error while getting a new Restlet instance: " + e.getMessage(), MediaType.TEXT_PLAIN);
                Object var6_7 = null;
                if (!started) return;
                TransactionHelper.commitOrRollbackTransaction();
                return;
            }
            Object var6_6 = null;
            if (!started) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!started) throw throwable;
            TransactionHelper.commitOrRollbackTransaction();
            throw throwable;
        }
        TransactionHelper.commitOrRollbackTransaction();
    }
}

