/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.text.DateFormat;
import java.util.Date;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.w3c.dom.Element;

public class LockingRestlet
extends BaseStatelessNuxeoRestlet {
    public static final String LOCK = "lock";
    public static final String UNLOCK = "unlock";
    public static final String STATUS = "status";
    public static final String SC_LOCKINFO_LOCKED = "LOCKED";
    public static final String SC_LOCKINFO_NOT_LOCKED = "NOTLOCKED";
    public static final String SC_LOCKED_OK = "OK";
    public static final String SC_ALREADY_LOCKED_KO = "ALREADYLOCKED";
    public static final String SC_ALREADY_LOCKED_OK = "ALREADYLOCKEDBYYOU";
    public static final String SC_UNLOCKED_OK = "OK";
    public static final String SC_ALREADY_UNLOCKED_OK = "NOT LOCKED";

    protected void doHandleStatelessRequest(Request req, Response res) {
        String existingLock;
        String repoId = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        Boolean initOk = super.initRepositoryAndTargetDocument(res, repoId, docid);
        if (!initOk.booleanValue()) {
            return;
        }
        String cUserName = LockingRestlet.getUserPrincipal(req).getName();
        String action = STATUS;
        if (req.getResourceRef().getSegments().size() > 5) {
            action = ((String)req.getResourceRef().getSegments().get(5)).toLowerCase();
        }
        if (req.getMethod().equals((Object)Method.LOCK)) {
            action = LOCK;
        }
        if (req.getMethod().equals((Object)Method.UNLOCK)) {
            action = UNLOCK;
        }
        String response = "";
        String code = "";
        if (action.equals(LOCK)) {
            try {
                existingLock = this.session.getLock(this.targetDocRef);
                String lockingUser = LockingRestlet.getUserFromLockToken(existingLock);
                String userLockKey = LockingRestlet.getLockToken(cUserName);
                if (existingLock == null || "".equals(existingLock.trim())) {
                    this.session.setLock(this.targetDocRef, userLockKey);
                    this.session.save();
                    response = "lock aquired on document " + docid;
                    code = "OK";
                }
                if (lockingUser.equals(cUserName)) {
                    response = "document " + docid + " is already locked by you";
                    code = SC_ALREADY_LOCKED_OK;
                }
                response = "document " + docid + " is already locked by " + lockingUser;
                code = SC_ALREADY_LOCKED_KO;
            }
            catch (ClientException e) {
                LockingRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
        } else if (action.equals(UNLOCK)) {
            try {
                existingLock = this.session.getLock(this.targetDocRef);
                String lockingUser = LockingRestlet.getUserFromLockToken(existingLock);
                if (existingLock == null) {
                    response = "document " + docid + " is not locked";
                    code = SC_ALREADY_UNLOCKED_OK;
                }
                if (lockingUser.equals(cUserName)) {
                    this.session.unlock(this.targetDocRef);
                    this.session.save();
                    response = "document " + docid + " unlocked";
                    code = "OK";
                }
                response = "document " + docid + " is locked by " + existingLock;
                code = SC_ALREADY_LOCKED_KO;
            }
            catch (ClientException e) {
                LockingRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
        } else if (action.equals(STATUS)) {
            try {
                response = this.session.getLock(this.targetDocRef);
                if (response == null || "".equals(response)) {
                    code = SC_LOCKINFO_NOT_LOCKED;
                }
                code = SC_LOCKINFO_LOCKED;
            }
            catch (ClientException e) {
                LockingRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
        } else {
            LockingRestlet.handleError(result, res, "Unsupported operation");
            return;
        }
        Element current = result.createElement("document");
        current.setAttribute("code", code);
        current.setAttribute("message", response);
        result.setRootElement((org.dom4j.Element)current);
        res.setEntity(result.asXML(), MediaType.TEXT_XML);
    }

    private static String getLockToken(String user) {
        return user + ":" + DateFormat.getDateInstance(2).format(new Date());
    }

    private static String getUserFromLockToken(String token) {
        if (token == null) {
            return null;
        }
        if (token.contains(":")) {
            return token.split(":")[0];
        }
        return null;
    }
}

