/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.io.DocumentPipe;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveWriter;
import org.nuxeo.ecm.core.io.impl.plugins.SingleDocumentReader;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentTreeWriter;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentWriter;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.restAPI.ExportRepresentation;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;

public class ExportRestlet
extends BaseStatelessNuxeoRestlet
implements Serializable {
    private static final long serialVersionUID = 7831287875548588711L;

    protected void doHandleStatelessRequest(Request req, Response res) {
        DocumentModel root;
        boolean exportAsZip;
        boolean exportAsTree;
        boolean needUnrestricted = false;
        String action = (String)req.getResourceRef().getSegments().get(4);
        if (action.equals("exportTree")) {
            exportAsTree = true;
            exportAsZip = true;
        } else {
            exportAsTree = false;
            String format = req.getResourceRef().getQueryAsForm().getFirstValue("format");
            format = format != null ? format.toLowerCase() : "xml";
            exportAsZip = "zip".equals(format);
        }
        String repo = (String)req.getAttributes().get("repo");
        if (repo == null || repo.equals("*")) {
            ExportRestlet.handleError(res, "you must specify a repository");
            return;
        }
        String docid = (String)req.getAttributes().get("docid");
        try {
            Boolean init = this.initRepository(res, repo);
            if (!init.booleanValue()) {
                ExportRestlet.handleError(res, "Unable to init repository");
                return;
            }
            if (docid == null || docid.equals("*")) {
                root = this.session.getRootDocument();
            } else if (this.session.hasPermission((DocumentRef)new IdRef(docid), "Read")) {
                root = this.session.getDocument((DocumentRef)new IdRef(docid));
            } else {
                UnrestrictedVersionExporter runner = new UnrestrictedVersionExporter(this.session, docid);
                runner.runUnrestricted();
                root = runner.root;
                needUnrestricted = true;
                if (root.isVersion()) {
                    DocumentModelList docs = this.session.getProxies(root.getRef(), null);
                    Boolean hasReadableProxy = false;
                    for (DocumentModel doc : docs) {
                        if (!this.session.hasPermission(doc.getRef(), "Read")) continue;
                        hasReadableProxy = true;
                        break;
                    }
                    if (!hasReadableProxy.booleanValue()) {
                        throw new ClientException("Current user doesn't have access to any proxy pointing to version " + root.getPathAsString());
                    }
                }
            }
        }
        catch (ClientException e) {
            ExportRestlet.handleError(res, (Exception)((Object)e));
            return;
        }
        if (exportAsZip) {
            String FILENAME = "export.zip";
            Map attributes = res.getAttributes();
            Form headers = (Form)attributes.get("org.restlet.http.headers");
            if (headers == null) {
                headers = new Form();
            }
            headers.add("Content-Disposition", String.format("attachment; filename=\"%s\";", FILENAME));
            attributes.put("org.restlet.http.headers", headers);
        }
        MediaType mediaType = exportAsZip ? MediaType.APPLICATION_ZIP : MediaType.TEXT_XML;
        Representation entity = this.makeRepresentation(mediaType, root, exportAsTree, exportAsZip, needUnrestricted);
        res.setEntity(entity);
    }

    protected Representation makeRepresentation(MediaType mediaType, DocumentModel root, final boolean exportAsTree, final boolean exportAsZip, boolean isUnrestricted) {
        return new ExportRepresentation(mediaType, root, isUnrestricted){

            protected DocumentPipe makePipe() {
                if (exportAsTree) {
                    return new DocumentPipeImpl(10);
                }
                return new DocumentPipeImpl();
            }

            protected DocumentReader makeDocumentReader(CoreSession documentManager, DocumentModel root) throws ClientException {
                SingleDocumentReader documentReader;
                if (exportAsTree) {
                    documentReader = new DocumentTreeReader(documentManager, root, false);
                    if (!exportAsZip) {
                        ((DocumentTreeReader)documentReader).setInlineBlobs(true);
                    }
                } else {
                    documentReader = new SingleDocumentReader(documentManager, root);
                }
                return documentReader;
            }

            protected DocumentWriter makeDocumentWriter(OutputStream outputStream) throws IOException {
                Object documentWriter = exportAsZip ? new NuxeoArchiveWriter(outputStream) : (exportAsTree ? new XMLDocumentTreeWriter(outputStream) : new XMLDocumentWriter(outputStream));
                return documentWriter;
            }
        };
    }

    protected static class UnrestrictedVersionExporter
    extends UnrestrictedSessionRunner {
        private final String docid;
        public DocumentModel root;

        public UnrestrictedVersionExporter(CoreSession session, String docId) {
            super(session);
            this.docid = docId;
        }

        public void run() throws ClientException {
            this.root = this.session.getDocument((DocumentRef)new IdRef(this.docid));
        }
    }
}

