/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.OutputStream;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.io.DocumentPipe;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.MediaType;
import org.restlet.resource.OutputRepresentation;

public abstract class ExportRepresentation
extends OutputRepresentation {
    private static final Log log = LogFactory.getLog(ExportRepresentation.class);
    protected final String repositoryName;
    protected final String rootId;
    protected final boolean isUnrestricted;

    protected ExportRepresentation(MediaType mediaType, DocumentModel root) {
        super(mediaType);
        this.repositoryName = root.getRepositoryName();
        this.rootId = root.getId();
        this.isUnrestricted = false;
    }

    protected ExportRepresentation(MediaType mediaType, DocumentModel root, boolean unrestricted) {
        super(mediaType);
        this.repositoryName = root.getRepositoryName();
        this.rootId = root.getId();
        this.isUnrestricted = unrestricted;
    }

    protected abstract DocumentPipe makePipe();

    protected abstract DocumentReader makeDocumentReader(CoreSession var1, DocumentModel var2) throws Exception;

    protected abstract DocumentWriter makeDocumentWriter(OutputStream var1) throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(OutputStream outputStream) throws IOException {
        DocumentWriter documentWriter;
        LoginContext loginContext;
        CoreSession documentManager;
        block26: {
            Repository repository = null;
            documentManager = null;
            loginContext = null;
            if (this.isUnrestricted) {
                try {
                    loginContext = Framework.login();
                }
                catch (LoginException e) {
                    log.error((Object)e);
                    throw new IOException();
                }
                try {
                    repository = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepository(this.repositoryName);
                    if (repository == null) {
                        throw new ClientException("Cannot get repository: " + this.repositoryName);
                    }
                    documentManager = repository.open();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            } else {
                try {
                    repository = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getRepository(this.repositoryName);
                }
                catch (Exception e) {
                    log.error((Object)"Could not get the repository", (Throwable)e);
                    throw new IOException();
                }
                try {
                    documentManager = repository.open();
                }
                catch (Exception e) {
                    log.error((Object)"Could not open the repository", (Throwable)e);
                    throw new IOException();
                }
            }
            DocumentReader documentReader = null;
            documentWriter = null;
            try {
                try {
                    DocumentModel root = documentManager.getDocument((DocumentRef)new IdRef(this.rootId));
                    documentReader = this.makeDocumentReader(documentManager, root);
                    documentWriter = this.makeDocumentWriter(outputStream);
                    DocumentPipe pipe = this.makePipe();
                    pipe.setReader(documentReader);
                    pipe.setWriter(documentWriter);
                    pipe.run();
                }
                catch (Exception e) {
                    log.error((Object)"Error during export", (Throwable)e);
                    throw new IOException();
                }
                Object var10_14 = null;
                if (documentReader == null) break block26;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                if (documentReader != null) {
                    documentReader.close();
                }
                if (documentWriter != null) {
                    documentWriter.close();
                }
                try {
                    if (loginContext != null) {
                        loginContext.logout();
                    }
                }
                catch (LoginException e) {
                    log.error((Object)e);
                    throw new IOException();
                }
                try {
                    Repository.close((CoreSession)documentManager);
                    throw throwable;
                }
                catch (Exception e) {
                    log.error((Object)"Could not close the session", (Throwable)e);
                    throw new IOException();
                }
            }
            documentReader.close();
        }
        if (documentWriter != null) {
            documentWriter.close();
        }
        try {}
        catch (LoginException e) {
            log.error((Object)e);
            throw new IOException();
        }
        if (loginContext != null) {
            loginContext.logout();
        }
        try {}
        catch (Exception e) {
            log.error((Object)"Could not close the session", (Throwable)e);
            throw new IOException();
        }
        Repository.close((CoreSession)documentManager);
    }
}

