/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="creationContainerListRestlet")
@Scope(value=ScopeType.EVENT)
public class CreationContainerListRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    private static final Log log = LogFactory.getLog(CreationContainerListRestlet.class);
    private static final long serialVersionUID = 5403775170948512675L;

    public void handle(Request req, Response res) {
        DocumentModelList containers = null;
        String docType = CreationContainerListRestlet.getQueryParamValue(req, "docType", "File");
        try {
            FileManager fileManager = (FileManager)Framework.getService(FileManager.class);
            containers = fileManager.getCreationContainers(CreationContainerListRestlet.getUserPrincipal(req), docType);
        }
        catch (Exception e) {
            CreationContainerListRestlet.handleError(res, e);
        }
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument resultDocument = (DOMDocument)domfactory.createDocument();
        Element containersElement = resultDocument.addElement("containers");
        for (DocumentModel parent : containers) {
            Element docElement = containersElement.addElement(documentTag);
            docElement.addElement(docRepositoryTag).setText(parent.getRepositoryName());
            docElement.addElement(docRefTag).setText(parent.getRef().toString());
            try {
                docElement.addElement(docTitleTag).setText(parent.getTitle());
            }
            catch (ClientException e) {
                log.error((Object)("not setting doc title tag: " + (Object)((Object)e)));
            }
            docElement.addElement(docPathTag).setText(parent.getPathAsString());
        }
        res.setEntity(resultDocument.asXML(), MediaType.TEXT_XML);
        res.getEntity().setCharacterSet(CharacterSet.UTF_8);
    }
}

