/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.directory.CSLData;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectoryFunctions {
    private DirectoryFunctions() {
    }

    public static List<CSLData> getCSLData(String data) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        String[] items = data.split(",");
        ArrayList<CSLData> result = new ArrayList<CSLData>();
        for (int i = 0; i < items.length; ++i) {
            CSLData obj = new CSLData(i, items[i]);
            result.add(obj);
        }
        return result;
    }

    public static int getListSize(String data) {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        String[] items = data.split(",");
        return items.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentModel getDirectoryEntry(String directoryName, String entryId) throws Exception {
        DocumentModel documentModel;
        block3: {
            if (entryId == null) {
                return null;
            }
            Session session = null;
            try {
                DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
                session = dirService.open(directoryName);
                documentModel = session.getEntry(entryId);
                Object var6_5 = null;
                if (session == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (session == null) break block4;
                    session.close();
                }
                throw throwable;
            }
            session.close();
        }
        return documentModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentModelList getDirectoryEntries(String directoryName, String ... entryIds) throws Exception {
        DocumentModelListImpl documentModelListImpl;
        block4: {
            if (entryIds == null) {
                return null;
            }
            Session session = null;
            try {
                DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
                session = dirService.open(directoryName);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (String entryId : entryIds) {
                    DocumentModel entry = session.getEntry(entryId);
                    if (entry == null) continue;
                    result.add((Object)entry);
                }
                documentModelListImpl = result;
                Object var11_10 = null;
                if (session == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var11_11 = null;
                    if (session == null) break block5;
                    session.close();
                }
                throw throwable;
            }
            session.close();
        }
        return documentModelListImpl;
    }

    public static DocumentModelList getDirectoryListEntries(String directoryName, Collection<String> entryIds) throws Exception {
        if (entryIds == null) {
            return null;
        }
        return DirectoryFunctions.getDirectoryEntries(directoryName, entryIds.toArray(new String[0]));
    }
}

