/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.list;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.component.list.EditableListModificationType;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.model.EditableModel;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableListBean {
    private static final Log log = LogFactory.getLog(EditableListBean.class);
    public static final String FOR_PARAMETER_NAME = "for";
    public static final String INDEX_PARAMETER_NAME = "index";
    public static final String TYPE_PARAMETER_NAME = "type";
    public static final String NUMBER_PARAMETER_NAME = "number";
    protected UIComponent binding;

    public UIComponent getBinding() {
        return this.binding;
    }

    public void setBinding(UIComponent binding) {
        this.binding = binding;
    }

    public void performAction(String listComponentId, String index, String type) {
        if (this.binding == null) {
            log.error((Object)"Component binding not set, cannot perform action");
            return;
        }
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put(FOR_PARAMETER_NAME, listComponentId);
        requestMap.put(INDEX_PARAMETER_NAME, index);
        requestMap.put(TYPE_PARAMETER_NAME, type);
        EditableListBean.performAction(this.binding, requestMap);
    }

    public void performAction(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        Map requestMap = eContext.getRequestParameterMap();
        EditableListBean.performAction(component, requestMap);
    }

    public void resetAllListsCachedModels(ActionEvent event) {
        UIComponent component = event.getComponent();
        if (component == null) {
            return;
        }
        UIComponent anchor = ComponentUtils.getBase(component);
        this.resetListCachedModels(anchor);
    }

    protected void resetListCachedModels(UIComponent parent) {
        List children;
        if (parent == null) {
            return;
        }
        if (parent instanceof UIEditableList) {
            ((UIEditableList)parent).resetCachedModel();
        }
        if ((children = parent.getChildren()) != null && !children.isEmpty()) {
            for (UIComponent child : children) {
                this.resetListCachedModels(child);
            }
        }
    }

    private static Object getUnreferencedTemplate(Object template) {
        if (!(template instanceof Serializable)) {
            return template;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(template);
            oos.close();
            byte[] pickled = out.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(pickled);
            ObjectInputStream ois = new ObjectInputStream(in);
            Object newTemplate = ois.readObject();
            return newTemplate;
        }
        catch (IOException e) {
            return template;
        }
        catch (ClassNotFoundException e) {
            return template;
        }
    }

    protected static void performAction(UIComponent binding, Map<String, String> requestMap) {
        UIEditableList editableComp = EditableListBean.getEditableListComponent(binding, requestMap);
        if (editableComp == null) {
            return;
        }
        EditableListModificationType type = EditableListBean.getModificationType(requestMap);
        if (type == null) {
            return;
        }
        EditableModel model = editableComp.getEditableModel();
        Object template = editableComp.getTemplate();
        switch (type) {
            case ADD: {
                Integer number = EditableListBean.getNumber(requestMap);
                if (number == null) {
                    model.addValue(template);
                    break;
                }
                for (int i = 0; i < number; ++i) {
                    model.addValue(EditableListBean.getUnreferencedTemplate(template));
                }
                break;
            }
            case INSERT: {
                Integer index = EditableListBean.getIndex(requestMap);
                if (index == null) {
                    return;
                }
                Integer number = EditableListBean.getNumber(requestMap);
                if (number == null) {
                    model.insertValue(index, template);
                    break;
                }
                for (int i = 0; i < number; ++i) {
                    model.insertValue(index, EditableListBean.getUnreferencedTemplate(template));
                }
                break;
            }
            case REMOVE: {
                Integer index = EditableListBean.getIndex(requestMap);
                if (index == null) {
                    return;
                }
                model.removeValue(index);
            }
        }
    }

    protected static String getParameterValue(Map<String, String> requestMap, String parameterName) {
        String string = requestMap.get(parameterName);
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    protected static UIEditableList getEditableListComponent(UIComponent component, Map<String, String> requestMap) {
        UIEditableList listComponent = null;
        String forString = EditableListBean.getParameterValue(requestMap, FOR_PARAMETER_NAME);
        if (forString == null) {
            log.error((Object)String.format("Could not find '%s' parameter in the request map", FOR_PARAMETER_NAME));
        } else {
            try {
                UIComponent forComponent = component.findComponent(forString);
                if (forComponent == null) {
                    log.error((Object)("Could not find component with id: " + forString));
                } else if (!(forComponent instanceof UIEditableList)) {
                    log.error((Object)String.format("Invalid component with id %s: %s, expected a component with class %s", forString, forComponent, UIEditableList.class));
                } else {
                    listComponent = (UIEditableList)forComponent;
                }
            }
            catch (Exception e) {
                log.error((Object)("Caught exception while looking for component with id: " + forString));
            }
        }
        return listComponent;
    }

    protected static EditableListModificationType getModificationType(Map<String, String> requestMap) {
        EditableListModificationType type = null;
        String typeString = EditableListBean.getParameterValue(requestMap, TYPE_PARAMETER_NAME);
        if (typeString == null) {
            log.error((Object)String.format("Could not find '%s' parameter in the request map", TYPE_PARAMETER_NAME));
        } else {
            try {
                type = EditableListModificationType.valueOfString(typeString);
            }
            catch (IllegalArgumentException err) {
                log.error((Object)String.format("Illegal value for '%s' attribute: %s, should be one of %s", new Object[]{TYPE_PARAMETER_NAME, typeString, EditableListModificationType.values()}));
            }
        }
        return type;
    }

    protected static Integer getIndex(Map<String, String> requestMap) {
        Integer index = null;
        String indexString = EditableListBean.getParameterValue(requestMap, INDEX_PARAMETER_NAME);
        if (indexString == null) {
            log.error((Object)String.format("Could not find '%s' parameter in the request map", INDEX_PARAMETER_NAME));
        } else {
            try {
                index = Integer.valueOf(indexString);
            }
            catch (Exception e) {
                log.error((Object)String.format("Illegal value for '%s' attribute: %s, should be integer", INDEX_PARAMETER_NAME, indexString));
            }
        }
        return index;
    }

    protected static Integer getNumber(Map<String, String> requestMap) {
        Integer number = null;
        String numberString = EditableListBean.getParameterValue(requestMap, NUMBER_PARAMETER_NAME);
        if (numberString != null) {
            try {
                number = Integer.valueOf(numberString);
            }
            catch (Exception e) {
                log.error((Object)String.format("Illegal value for '%s' attribute: %s, should be integer", NUMBER_PARAMETER_NAME, numberString));
            }
        }
        return number;
    }

    public List<Object> getDummyList() {
        ArrayList<Object> dummy = new ArrayList<Object>(1);
        dummy.add("dummy");
        return dummy;
    }
}

