/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.document;

import java.util.HashMap;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.html.HtmlOutputLink;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

public class RestDocumentLink
extends HtmlOutputLink {
    public static final String COMPONENT_FAMILY = RestDocumentLink.class.getName();
    public static final String DEFAULT_VIEW_ID = "view_documents";
    protected DocumentModel document;
    protected DocumentRef documentIdRef;
    protected String view;
    protected String tab;
    protected String subTab;
    protected String pattern;
    protected Boolean newConversation;

    public Object getValue() {
        DocumentModel doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        String viewId = this.getView();
        HashMap<String, String> params = new HashMap<String, String>();
        String tabValue = this.getTab();
        String subTabValue = this.getSubTab();
        if (tabValue != null) {
            params.put("tabId", tabValue);
            if (subTabValue != null) {
                params.put("subTabId", subTabValue);
            }
        } else {
            params.put("tabId", "");
        }
        String pattern = this.getPattern();
        Boolean nc = this.getNewConversation();
        return DocumentModelFunctions.documentUrl(pattern, doc, viewId, params, nc != null ? nc : false);
    }

    public String getPattern() {
        if (this.pattern != null) {
            return this.pattern;
        }
        ValueExpression ve = this.getValueExpression("pattern");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setPattern(String codec) {
        this.pattern = codec;
    }

    public DocumentModel getDocument() {
        if (this.document != null) {
            return this.document;
        }
        ValueExpression ve = this.getValueExpression("document");
        if (ve != null) {
            try {
                return (DocumentModel)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDocument(DocumentModel document) {
        this.document = document;
    }

    public DocumentRef getDocumentIdRef() {
        if (this.documentIdRef != null) {
            return this.documentIdRef;
        }
        ValueExpression ve = this.getValueExpression("documentIdRef");
        if (ve != null) {
            try {
                String id = (String)ve.getValue(this.getFacesContext().getELContext());
                if (id != null) {
                    return new IdRef(id);
                }
                return null;
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDocumentIdRef(DocumentRef documentIdRef) {
        this.documentIdRef = documentIdRef;
    }

    public Boolean getNewConversation() {
        if (this.newConversation != null) {
            return this.newConversation;
        }
        ValueExpression ve = this.getValueExpression("newConversation");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return false;
    }

    public void setNewConversation(Boolean newConversation) {
        this.newConversation = newConversation;
    }

    public String getSubTab() {
        if (this.subTab != null) {
            return this.subTab;
        }
        ValueExpression ve = this.getValueExpression("subTab");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setSubTab(String subTab) {
        this.subTab = subTab;
    }

    public String getTab() {
        if (this.tab != null) {
            return this.tab;
        }
        ValueExpression ve = this.getValueExpression("tab");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public String getView() {
        if (this.view != null) {
            return this.view;
        }
        ValueExpression ve = this.getValueExpression("view");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setView(String view) {
        this.view = view;
    }
}

