/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.date;

import java.util.TimeZone;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIInputDateTime
extends UIInput {
    public static final String COMPONENT_TYPE = UIInputDateTime.class.getName();
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    private static final Log log = LogFactory.getLog(UIInputDateTime.class);
    private String format;
    private Boolean showsTime;
    private String locale;
    private String timeZone;
    private String triggerLabel;
    protected String onchange;
    protected String onclick;
    protected String onselect;

    public UIInputDateTime() {
        this.setRendererType(COMPONENT_TYPE);
    }

    public Converter getConverter() {
        return this.getDateTimeConverter();
    }

    public DateTimeConverter getDateTimeConverter() {
        DateTimeConverter converter = new DateTimeConverter();
        String timeZone = this.getTimeZone();
        converter.setTimeZone(TimeZone.getTimeZone(timeZone));
        converter.setPattern(this.getFormat());
        return converter;
    }

    public String getFormat() {
        if (this.format != null) {
            return this.format;
        }
        ValueExpression ve = this.getValueExpression("format");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return "dd/MM/yyyy HH:mm";
    }

    public void setFormat(String format) {
        this.format = format;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        ValueExpression ve = this.getValueExpression("timeZone");
        if (ve != null) {
            try {
                Object t = ve.getValue(this.getFacesContext().getELContext());
                if (t instanceof TimeZone) {
                    this.timeZone = ((TimeZone)t).getID();
                    return this.timeZone;
                }
                if (!(t instanceof String)) return this.timeZone;
                this.timeZone = (String)t;
                return this.timeZone;
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        } else {
            this.timeZone = TimeZone.getDefault().getID();
        }
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Boolean getShowsTime() {
        if (this.showsTime != null) {
            return this.showsTime;
        }
        ValueExpression ve = this.getValueExpression("showsTime");
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return true;
    }

    public void setShowsTime(Boolean showsTime) {
        this.showsTime = showsTime;
    }

    public String getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        ValueExpression ve = this.getValueExpression("locale");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getTriggerLabel() {
        if (this.triggerLabel != null) {
            return this.triggerLabel;
        }
        ValueExpression ve = this.getValueExpression("triggerLabel");
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return "...";
    }

    public void setTriggerLabel(String triggerLabel) {
        this.triggerLabel = triggerLabel;
    }

    protected String getStringValue(String name, String defaultValue) {
        ValueExpression ve = this.getValueExpression(name);
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return defaultValue;
    }

    public String getOnchange() {
        if (this.onchange != null) {
            return this.onchange;
        }
        return this.getStringValue("onchange", null);
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getOnclick() {
        if (this.onclick != null) {
            return this.onclick;
        }
        return this.getStringValue("onclick", null);
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public String getOnselect() {
        if (this.onselect != null) {
            return this.onselect;
        }
        return this.getStringValue("onselect", null);
    }

    public void setOnselect(String onselect) {
        this.onselect = onselect;
    }

    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.format, this.showsTime, this.locale, this.timeZone, this.triggerLabel, this.onchange, this.onclick, this.onselect};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.format = (String)values[1];
        this.showsTime = (Boolean)values[2];
        this.locale = (String)values[3];
        this.timeZone = (String)values[4];
        this.triggerLabel = (String)values[5];
        this.onchange = (String)values[6];
        this.onclick = (String)values[7];
        this.onselect = (String)values[8];
    }
}

