/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.date;

import com.sun.faces.renderkit.html_basic.HtmlBasicInputRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.component.date.UIInputDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputDateTimeRenderer
extends HtmlBasicInputRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String onselect;
        String onclick;
        if (!component.isRendered()) {
            return;
        }
        UIInputDateTime dateTimeComp = (UIInputDateTime)component;
        ResponseWriter writer = context.getResponseWriter();
        String localeString = dateTimeComp.getLocale();
        if (localeString == null) {
            Locale locale = context.getViewRoot().getLocale();
            localeString = locale.getLanguage();
        }
        writer.startElement("script", (UIComponent)dateTimeComp);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)String.format("jscalendar/lang/calendar-%s.js", localeString), null);
        writer.write(" ");
        writer.endElement("script");
        String inputTextId = dateTimeComp.getClientId(context);
        String triggerButtonId = inputTextId + ":trigger";
        writer.startElement("input", (UIComponent)dateTimeComp);
        writer.writeAttribute("type", (Object)"text", null);
        String onchange = dateTimeComp.getOnchange();
        if (onchange != null) {
            writer.writeAttribute("onchange", (Object)onchange, "onchange");
        }
        if ((onclick = dateTimeComp.getOnclick()) != null) {
            writer.writeAttribute("onclick", (Object)onclick, "onclick");
        }
        if ((onselect = dateTimeComp.getOnselect()) != null) {
            writer.writeAttribute("onselect", (Object)onselect, "onselect");
        }
        writer.writeAttribute("id", (Object)inputTextId, null);
        writer.writeAttribute("name", (Object)inputTextId, null);
        Object currentValue = InputDateTimeRenderer.getCurrentValue(dateTimeComp);
        writer.writeAttribute("value", (Object)this.getFormattedValue(context, component, currentValue), null);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.endElement("input");
        writer.startElement("button", (UIComponent)dateTimeComp);
        writer.writeAttribute("type", (Object)"reset", null);
        writer.writeAttribute("id", (Object)triggerButtonId, null);
        writer.writeAttribute("name", (Object)triggerButtonId, null);
        String triggerStyleClass = (String)component.getAttributes().get("triggerStyleClass");
        if (triggerStyleClass != null) {
            writer.writeAttribute("class", (Object)triggerStyleClass, "styleClass");
        }
        writer.writeText((Object)dateTimeComp.getTriggerLabel(), null);
        writer.endElement("button");
        writer.startElement("script", (UIComponent)dateTimeComp);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("inputField", inputTextId);
        options.put("button", triggerButtonId);
        String showsTime = dateTimeComp.getShowsTime() != false ? "true" : "";
        options.put("showsTime", showsTime);
        options.put("ifFormat", InputDateTimeRenderer.convertFormat(dateTimeComp.getFormat()));
        String calendarSetup = String.format("Calendar.setup(%s);", InputDateTimeRenderer.generateOptions(options));
        writer.writeText((Object)calendarSetup, null);
        writer.endElement("script");
        writer.flush();
    }

    protected static Object getCurrentValue(UIInputDateTime comp) {
        Object submitted = comp.getSubmittedValue();
        if (submitted != null) {
            return submitted;
        }
        return comp.getValue();
    }

    protected static String convertFormat(String format) {
        String jsFormat = format;
        if (!(jsFormat = jsFormat.replace("dd", "%d")).contains("%d")) {
            jsFormat = jsFormat.replace("d", "%e");
        }
        jsFormat = jsFormat.replace("MMM", "%b");
        if (!(jsFormat = jsFormat.replace("MM", "%m")).contains("%M")) {
            jsFormat = jsFormat.replace("M", "%m");
        }
        jsFormat = jsFormat.replace("yyyy", "%Y");
        jsFormat = jsFormat.replace("yy", "%y");
        jsFormat = jsFormat.replace("mm", "%M");
        jsFormat = jsFormat.replace("HH", "%H");
        if (!(jsFormat = jsFormat.replace("hh", "%I")).contains("%H")) {
            jsFormat = jsFormat.replace("H", "%H");
        }
        if (!jsFormat.contains("%h")) {
            jsFormat = jsFormat.replace("h", "%I");
        }
        jsFormat = jsFormat.replace("a", "%p");
        return jsFormat;
    }

    protected static String generateOptions(Map<String, String> options) {
        ArrayList<String> strOptions = new ArrayList<String>();
        for (Map.Entry<String, String> option : options.entrySet()) {
            strOptions.add(String.format("%s : \"%s\"", option.getKey(), option.getValue()));
        }
        StringBuilder res = new StringBuilder();
        res.append('{');
        res.append(StringUtils.join((Object[])strOptions.toArray(), (String)", "));
        res.append('}');
        return res.toString();
    }
}

