/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.core.listener;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishRelationsListener
implements EventListener {
    private static final Log log = LogFactory.getLog(PublishRelationsListener.class);
    protected RelationManager rmanager = null;
    protected List<String> graphNamesForCopyFromWork = Arrays.asList("default");
    protected List<String> graphNamesForCopyFromReplacedProxy = Arrays.asList("default", "documentComments");

    public RelationManager getRelationManager() throws ClientException {
        if (this.rmanager == null) {
            try {
                this.rmanager = (RelationManager)Framework.getService(RelationManager.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.rmanager;
    }

    public List<String> getGraphNamesForCopyFromWork() throws ClientException {
        if (this.graphNamesForCopyFromWork == null) {
            return this.getRelationManager().getGraphNames();
        }
        return this.graphNamesForCopyFromWork;
    }

    public List<String> getGraphNamesForCopyFromReplacedProxy() throws ClientException {
        if (this.graphNamesForCopyFromReplacedProxy == null) {
            return this.getRelationManager().getGraphNames();
        }
        return this.graphNamesForCopyFromReplacedProxy;
    }

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel publishedDoc = docCtx.getSourceDocument();
            if (!publishedDoc.isProxy()) {
                return;
            }
            CoreSession session = ctx.getCoreSession();
            RelationManager rmanager = this.getRelationManager();
            DocumentModel sourceDoc = session.getSourceDocument(publishedDoc.getRef());
            if ((sourceDoc = session.getSourceDocument(sourceDoc.getRef())) == null) {
                log.warn((Object)"working version of the proxy is no longer available, cannot copy the relations");
                return;
            }
            Resource sourceResource = rmanager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)sourceDoc, null);
            Resource publishedResource = rmanager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)publishedDoc, null);
            this.copyRelationsFromWorkVersion(rmanager, sourceResource, publishedResource);
            List replacedProxyIds = (List)ctx.getProperties().get("replacedProxyRefs");
            if (replacedProxyIds != null) {
                for (String replacedProxyId : replacedProxyIds) {
                    DocumentLocationImpl docLoc = new DocumentLocationImpl(ctx.getRepositoryName(), new IdRef(replacedProxyId), null);
                    Resource replacedResource = rmanager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)docLoc, null);
                    this.copyRelationsFromReplacedProxy(rmanager, replacedResource, publishedResource, sourceResource);
                }
            }
        }
    }

    protected void copyRelationsFromReplacedProxy(RelationManager rmanager, Resource replacedResource, Resource publishedResource, Resource sourceResource) throws ClientException {
        StatementImpl sourcePattern = new StatementImpl((Node)replacedResource, null, null);
        StatementImpl targetPattern = new StatementImpl(null, null, (Node)replacedResource);
        for (String graphName : this.getGraphNamesForCopyFromReplacedProxy()) {
            ArrayList<Statement> newStatements = new ArrayList<Statement>();
            for (Statement stmt : rmanager.getStatements(graphName, (Statement)sourcePattern)) {
                if (this.isCopyFromSource(stmt, sourceResource)) continue;
                stmt.setSubject((Node)publishedResource);
                newStatements.add(stmt);
            }
            for (Statement stmt : rmanager.getStatements(graphName, (Statement)targetPattern)) {
                if (this.isCopyFromSource(stmt, sourceResource)) continue;
                stmt.setObject((Node)publishedResource);
                newStatements.add(stmt);
            }
            if (newStatements.isEmpty()) continue;
            rmanager.add(graphName, newStatements);
        }
    }

    protected boolean isCopyFromSource(Statement stmt, Resource sourceResource) {
        Node[] values = stmt.getProperties(RelationConstants.COPY_FROM_WORK_VERSION);
        if (values == null) {
            return false;
        }
        return Arrays.asList(values).contains(sourceResource);
    }

    protected void copyRelationsFromWorkVersion(RelationManager rmanager, Resource sourceResource, Resource publishedResource) throws ClientException {
        StatementImpl sourcePattern = new StatementImpl((Node)sourceResource, null, null);
        StatementImpl targetPattern = new StatementImpl(null, null, (Node)sourceResource);
        for (String graphName : this.getGraphNamesForCopyFromWork()) {
            ArrayList<Statement> newStatements = new ArrayList<Statement>();
            for (Statement stmt : rmanager.getStatements(graphName, (Statement)sourcePattern)) {
                stmt.setSubject((Node)publishedResource);
                stmt.addProperty(RelationConstants.COPY_FROM_WORK_VERSION, (Node)sourceResource);
                newStatements.add(stmt);
            }
            for (Statement stmt : rmanager.getStatements(graphName, (Statement)targetPattern)) {
                stmt.setObject((Node)publishedResource);
                stmt.addProperty(RelationConstants.COPY_FROM_WORK_VERSION, (Node)sourceResource);
                newStatements.add(stmt);
            }
            if (newStatements.isEmpty()) continue;
            rmanager.add(graphName, newStatements);
        }
    }
}

