/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.CachableBlobHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCachableBlobHolder
extends SimpleBlobHolder
implements CachableBlobHolder {
    public SimpleCachableBlobHolder() {
    }

    public SimpleCachableBlobHolder(Blob blob) {
        super(blob);
    }

    public SimpleCachableBlobHolder(List<Blob> blobs) {
        super(blobs);
    }

    public SimpleCachableBlobHolder(String path) {
        super((Blob)new FileBlob(new File(path)));
    }

    @Override
    public void load(String path) {
        this.blobs = new ArrayList();
        File base = new File(path);
        try {
            if (base.isDirectory()) {
                this.addDirectoryToList(base, "");
            } else {
                File file = new File(path);
                FileBlob mainBlob = new FileBlob(file);
                mainBlob.setFilename(file.getName());
                this.blobs.add(mainBlob);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Blob loading from cache failed", e.getCause());
        }
    }

    public void addDirectoryToList(File directory, String prefix) throws ConversionException {
        File[] directoryContent;
        for (File file : directoryContent = directory.listFiles()) {
            if (file.isDirectory()) {
                int beginIndex = prefix.length();
                prefix = prefix.concat(file.getName() + File.separatorChar);
                this.addDirectoryToList(file, prefix);
                prefix = prefix.substring(0, beginIndex);
                continue;
            }
            FileBlob blob = new FileBlob(file);
            blob.setFilename(prefix.concat(file.getName()));
            if (file.getName().equalsIgnoreCase("index.html")) {
                this.blobs.add(0, blob);
                continue;
            }
            this.blobs.add(blob);
        }
    }

    @Override
    public String persist(String basePath) throws Exception {
        if (this.blobs == null || this.blobs.size() == 0) {
            return null;
        }
        Path path = new Path(basePath);
        path = path.append(this.getHash());
        if (this.blobs.size() == 1) {
            File file = new File(path.toString());
            this.getBlob().transferTo(file);
            return file.getAbsolutePath();
        }
        File dir = new File(path.toString());
        dir.mkdir();
        for (int i = 0; i < this.blobs.size(); ++i) {
            Blob blob = (Blob)this.blobs.get(i);
            File file = new File(path.append(blob.getFilename()).toString());
            blob.transferTo(file);
        }
        return dir.getAbsolutePath();
    }
}

