/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.objects.NativeArray;
import org.nuxeo.automation.scripting.internals.AutomationMapper;
import org.nuxeo.automation.scripting.internals.ScriptObjectMirrors;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.DataModelProperties;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.schema.DocumentType;

public class DocumentScriptingWrapper
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    protected final AutomationMapper mapper;
    protected final DocumentModel doc;

    public static Object wrap(Object object, AutomationMapper mapper) {
        if (object == null) {
            return null;
        }
        if (object instanceof DocumentModel) {
            return new DocumentScriptingWrapper(mapper, (DocumentModel)object);
        }
        if (object instanceof DocumentModelList) {
            ArrayList<DocumentScriptingWrapper> docs = new ArrayList<DocumentScriptingWrapper>();
            for (DocumentModel doc : (DocumentModelList)object) {
                docs.add(new DocumentScriptingWrapper(mapper, doc));
            }
            return docs;
        }
        if (object instanceof Map) {
            Map m = (Map)object;
            return DocumentScriptingWrapper.wrap(m, mapper);
        }
        return object;
    }

    public static Map<String, Object> wrap(Map<String, Object> source, AutomationMapper mapper) {
        return source.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> DocumentScriptingWrapper.wrap(e.getValue(), mapper)));
    }

    public static Object unwrap(Object object) {
        DocumentModel result = object;
        if (result instanceof ScriptObjectMirror) {
            result = ScriptObjectMirrors.unwrap((ScriptObjectMirror)result);
        }
        if (result instanceof NativeArray) {
            result = Arrays.asList(((NativeArray)result).asObjectArray());
        }
        if (result instanceof DocumentScriptingWrapper) {
            result = ((DocumentScriptingWrapper)result).getDoc();
        } else if (result instanceof List) {
            List l = (List)result;
            if (l.size() > 0 && !(result instanceof DocumentModelList) && !(result instanceof BlobList)) {
                Object first = l.get(0);
                if (first instanceof DocumentModel) {
                    result = l.stream().map(DocumentModel.class::cast).collect(Collectors.toCollection(DocumentModelListImpl::new));
                } else if (first instanceof Blob) {
                    result = l.stream().map(Blob.class::cast).collect(Collectors.toCollection(BlobList::new));
                } else if (first instanceof DocumentScriptingWrapper) {
                    result = l.stream().map(DocumentScriptingWrapper.class::cast).map(DocumentScriptingWrapper::getDoc).collect(Collectors.toCollection(DocumentModelListImpl::new));
                }
            }
        } else if (result instanceof Map) {
            Map map = (Map)result;
            result = DocumentScriptingWrapper.computeProperties(DocumentScriptingWrapper.unwrap(map));
        }
        return result;
    }

    protected static Properties computeProperties(Map<?, ?> result) {
        DataModelProperties props = new DataModelProperties();
        for (Map.Entry<?, ?> entry : result.entrySet()) {
            props.getMap().put(entry.getKey().toString(), (Serializable)entry.getValue());
        }
        return props;
    }

    public static Map<String, Object> unwrap(Map<String, Object> source) {
        return source.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> DocumentScriptingWrapper.unwrap(e.getValue())));
    }

    public DocumentScriptingWrapper(AutomationMapper mapper, DocumentModel doc) {
        this.mapper = mapper;
        this.doc = doc;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    public CoreSession getSession() {
        return this.mapper.ctx.getCoreSession();
    }

    public DocumentScriptingWrapper getParent() {
        DocumentModel parent = this.getSession().getParentDocument(this.doc.getRef());
        return parent != null ? new DocumentScriptingWrapper(this.mapper, parent) : null;
    }

    public DocumentScriptingWrapper getParent(String type) {
        DocumentModel parent = this.getSession().getParentDocument(this.doc.getRef());
        while (parent != null && !type.equals(parent.getType())) {
            parent = this.getSession().getParentDocument(parent.getRef());
        }
        if (parent == null) {
            return null;
        }
        return new DocumentScriptingWrapper(this.mapper, parent);
    }

    public DocumentScriptingWrapper getWorkspace() {
        return this.getParent("Workspace");
    }

    public DocumentScriptingWrapper getDomain() {
        return this.getParent("Domain");
    }

    public String getTitle() {
        return this.doc.getTitle();
    }

    public String getPath() {
        return this.doc.getPathAsString();
    }

    public String resolvePath(String relative) {
        return this.doc.getPath().append(relative).toString();
    }

    public DocumentRef getRef() {
        return this.doc.getRef();
    }

    public DocumentRef resolvePathAsRef(String relative) {
        return new PathRef(this.doc.getPath().append(relative).toString());
    }

    public String getDescription() {
        return (String)((Object)this.doc.getPropertyValue("dc:description"));
    }

    public boolean hasFacet(String facet) {
        return this.doc.hasFacet(facet);
    }

    public boolean hasSchema(String schema) {
        return this.doc.hasSchema(schema);
    }

    public boolean addFacet(String facet) {
        return this.doc.addFacet(facet);
    }

    public boolean removeFacet(String facet) {
        return this.doc.removeFacet(facet);
    }

    public String getType() {
        return this.doc.getType();
    }

    public DocumentType getDocumentType() {
        return this.doc.getDocumentType();
    }

    public String getLifeCycle() {
        return this.doc.getCurrentLifeCycleState();
    }

    public boolean isLocked() {
        return this.doc.isLocked();
    }

    public boolean isFolder() {
        return this.doc.isFolder();
    }

    public boolean isImmutable() {
        return this.doc.isImmutable();
    }

    public boolean isProxy() {
        return this.doc.isProxy();
    }

    public boolean isVersion() {
        return this.doc.isVersion();
    }

    public boolean isDownloadable() {
        return this.doc.isDownloadable();
    }

    public boolean isVersionable() {
        return this.doc.isVersionable();
    }

    public String getId() {
        return this.doc.getId();
    }

    public String getName() {
        return this.doc.getName();
    }

    public String[] getSchemas() {
        return this.doc.getSchemas();
    }

    public Set<String> getFacets() {
        return this.doc.getFacets();
    }

    public Serializable getProperty(String key) {
        return this.doc.getPropertyValue(key);
    }

    public Serializable getPropertyValue(String key) {
        return this.doc.getPropertyValue(key);
    }

    public void setProperty(String key, Serializable value) {
        this.doc.setPropertyValue(key, value);
    }

    public void setPropertyValue(String key, Serializable value) {
        this.doc.setPropertyValue(key, value);
    }

    public void setPropertyValue(String key, ScriptObjectMirror value) {
        this.doc.setPropertyValue(key, (Serializable)ScriptObjectMirrors.unwrap(value));
    }

    public String getVersionLabel() {
        return this.doc.getVersionLabel();
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.doc.getProperty(key.toString());
            return true;
        }
        catch (PropertyException e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.doc.getProperty(value.toString()).getValue() != null;
        }
        catch (PropertyException e) {
            return false;
        }
    }

    @Override
    public Serializable get(Object key) {
        try {
            return this.doc.getProperty(key.toString()).getValue();
        }
        catch (PropertyException e) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return Stream.of(this.doc.getParts()).collect(Collectors.summingInt(part -> part.size()));
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(Stream.of(this.doc.getSchemas()).map(name -> this.doc.getProperties(name).keySet().stream()).flatMap(s -> s).collect(Collectors.toSet()));
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(Stream.of(this.doc.getSchemas()).map(name -> this.doc.getProperties(name).values().stream()).flatMap(s -> s).collect(Collectors.toSet()));
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(Stream.of(this.doc.getSchemas()).flatMap(name -> this.doc.getProperties(name).entrySet().stream()).collect(Collectors.toSet()));
    }

    @Override
    public Object put(String key, Object value) {
        if (value instanceof ScriptObjectMirror) {
            return this.put(key, (Serializable)ScriptObjectMirrors.unwrap((ScriptObjectMirror)value));
        }
        return this.put(key, (Serializable)value);
    }

    @Override
    public Serializable put(String key, Serializable value) {
        Property p = this.doc.getProperty(key);
        Serializable v = p.getValue();
        p.setValue((Object)value);
        return v;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public Serializable remove(Object key) {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read Only Map.");
    }

    @Override
    public String toString() {
        return this.doc.toString();
    }
}

