/*
 * (C) Copyright 2015 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 *     Nelson Silva <nsilva@nuxeo.com>
 */
package org.nuxeo.ecm.automation.io.services.codec;

import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.io.NuxeoPrincipalJsonReader;
import org.nuxeo.ecm.platform.usermanager.io.NuxeoPrincipalJsonWriter;

/**
 * @since 8.2
 */
public class NuxeoPrincipalCodec extends AbstractMarshallingRegistryCodec<NuxeoPrincipal> {

    public NuxeoPrincipalCodec() {
        super(NuxeoPrincipal.class, "user", NuxeoPrincipalJsonReader.class, NuxeoPrincipalJsonWriter.class);
    }
}
