/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.util;

import java.io.IOException;
import java.util.ArrayList;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;

public class JsonOperationMarshaller {
    public static OperationDocumentation read(JsonParser jp) throws IOException {
        OperationDocumentation op = new OperationDocumentation();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("id".equals(key)) {
                op.id = jp.getText();
            } else if ("aliases".equals(key)) {
                op.aliases = JsonOperationMarshaller.readStringArray(jp);
            } else if ("label".equals(key)) {
                op.label = jp.getText();
            } else if ("category".equals(key)) {
                op.category = jp.getText();
            } else if ("requires".equals(key)) {
                op.requires = jp.getText();
            } else if ("description".equals(key)) {
                op.description = jp.getText();
            } else if ("url".equals(key)) {
                op.url = jp.getText();
            } else if ("since".equals(key)) {
                op.since = jp.getText();
            } else if ("signature".equals(key)) {
                op.signature = JsonOperationMarshaller.readStringArray(jp);
            } else if ("params".equals(key)) {
                JsonOperationMarshaller.readParams(jp, op);
            } else {
                jp.skipChildren();
            }
            tok = jp.nextToken();
        }
        if (tok == null) {
            throw new IllegalArgumentException("Unexpected end of stream.");
        }
        return op;
    }

    public static String[] readStringArray(JsonParser jp) throws IOException {
        JsonToken tok = jp.nextToken();
        if (tok == JsonToken.END_ARRAY) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        do {
            list.add(jp.getText());
        } while ((tok = jp.nextToken()) != JsonToken.END_ARRAY);
        return list.toArray(new String[list.size()]);
    }

    private static void readParams(JsonParser jp, OperationDocumentation op) throws IOException {
        JsonToken tok = jp.nextToken();
        if (tok == JsonToken.END_ARRAY) {
            return;
        }
        do {
            JsonOperationMarshaller.readParam(jp, op);
        } while ((tok = jp.nextToken()) != JsonToken.END_ARRAY);
    }

    private static void readParam(JsonParser jp, OperationDocumentation op) throws IOException {
        OperationDocumentation.Param para = new OperationDocumentation.Param();
        JsonToken tok = jp.nextToken();
        while (tok != null && tok != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if ("name".equals(key)) {
                para.name = jp.getText();
            } else if ("type".equals(key)) {
                para.type = jp.getText();
            } else if ("description".equals(key)) {
                para.description = jp.getText();
            } else if ("required".equals(key)) {
                para.isRequired = jp.getBooleanValue();
            } else if ("widget".equals(key)) {
                para.widget = jp.getText();
            } else if ("values".equals(key)) {
                para.values = JsonOperationMarshaller.readStringArray(jp);
            }
            tok = jp.nextToken();
        }
        op.params.add(para);
    }

    public static void write(JsonParser jp, OperationDocumentation op) {
    }
}

