/*
 * (C) Copyright 2006-2009 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     Nuxeo
 */

package org.nuxeo.dam;

import org.nuxeo.runtime.api.Framework;

public interface Constants {

    String IMPORT_ROOT_PATH = Framework.getProperty("import.root.path",
            "/default-domain/import-root");

    String DAM_COMMON_SCHEMA = "dam_common";

    String DUBLINCORE_SCHEMA = "dublincore";

    String PICTURE_SCHEMA = "picture";

    String IMPORT_ROOT_TYPE = "ImportRoot";

    String IMPORT_FOLDER_TYPE = "ImportFolder";

    String IMPORT_SET_TYPE = "ImportSet";

    String ASSET_FACET = "Asset";

    String DUBLINCORE_TITLE_PROPERTY = "dc:title";

    String DUBLINCORE_DESCRIPTION_PROPERTY = "dc:description";

    String DUBLINCORE_COVERAGE_PROPERTY = "dc:coverage";

    String DUBLINCORE_EXPIRED_PROPERTY = "dc:expired";

    String DUBLINCORE_CREATOR_PROPERTY = "dc:creator";

    String DUBLINCORE_CONTRIBUTORS_PROPERTY = "dc:contributors";

    String DAM_COMMON_AUTHOR_PROPERTY = "damc:author";

    String DAM_COMMON_AUTHORING_DATE_PROPERTY = "damc:authoringDate";

}
