/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.Arrays;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.dependencies.CUDFPackage;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.Version;

class NuxeoCUDFPackage
implements CUDFPackage {
    public final String newLine = System.getProperty("line.separator");
    protected DownloadablePackage pkg;
    protected int cudfVersion;
    protected String cudfName;
    protected boolean installed;

    public NuxeoCUDFPackage(DownloadablePackage pkg) {
        this.pkg = pkg;
        this.cudfName = pkg.getName();
        if ("nuxeo-content-browser".equals(this.cudfName) && "cmf".equalsIgnoreCase(pkg.getVersion().classifier())) {
            this.cudfName = this.cudfName + "*" + pkg.getVersion().classifier();
        }
        this.setInstalled(pkg.getPackageState().isInstalled());
    }

    protected NuxeoCUDFPackage() {
    }

    public void setPkg(DownloadablePackage pkg) {
        this.pkg = pkg;
        this.cudfName = pkg.getName();
        this.setInstalled(pkg.getPackageState().isInstalled());
    }

    @Override
    public String getCUDFName() {
        return this.cudfName;
    }

    public String getNuxeoName() {
        return this.pkg.getName();
    }

    public Version getNuxeoVersion() {
        return this.pkg.getVersion();
    }

    public void setCUDFVersion(int posInt) {
        this.cudfVersion = posInt;
    }

    @Override
    public int getCUDFVersion() {
        return this.cudfVersion;
    }

    public String toString() {
        return this.getCUDFName() + " CUDF {" + this.cudfVersion + "} Nuxeo {" + this.pkg.getVersion() + "} " + this.pkg.getClass();
    }

    @Override
    public String getCUDFStanza() {
        StringBuffer sb = new StringBuffer();
        sb.append("package: " + this.cudfName + this.newLine);
        sb.append("version: " + this.cudfVersion + this.newLine);
        sb.append("installed: " + this.installed + this.newLine);
        return sb.toString();
    }

    @Override
    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    @Override
    public boolean isInstalled() {
        return this.installed;
    }

    @Override
    public PackageDependency[] getDependencies() {
        return this.pkg.getDependencies();
    }

    @Override
    public PackageDependency[] getConflicts() {
        PackageDependency[] conflicts = this.pkg.getConflicts();
        if ("nuxeo-content-browser*cmf".equals(this.cudfName)) {
            return this.addToConflicts(conflicts, "nuxeo-content-browser");
        }
        if ("nuxeo-content-browser".equals(this.cudfName)) {
            return this.addToConflicts(conflicts, "nuxeo-content-browser*cmf");
        }
        return conflicts;
    }

    private PackageDependency[] addToConflicts(PackageDependency[] conflicts, String dep) {
        PackageDependency[] withContentBrowser = conflicts != null && conflicts.length > 0 ? Arrays.copyOf(conflicts, conflicts.length + 1) : new PackageDependency[1];
        withContentBrowser[withContentBrowser.length - 1] = new PackageDependency(dep);
        return withContentBrowser;
    }

    @Override
    public PackageDependency[] getProvides() {
        return this.pkg.getProvides();
    }

    public String getNuxeoId() {
        return this.pkg.getId();
    }

    public static String getCUDFName(PackageDependency dependency) {
        if ("nuxeo-content-browser".equals(dependency.getName()) && dependency.getVersionRange().toString().contains("cmf")) {
            return dependency.getName() + "*cmf";
        }
        return dependency.getName();
    }
}

