/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageCacheEntry;
import org.nuxeo.connect.packages.PackageListCacheEntry;
import org.nuxeo.connect.update.PackageType;

public class PackageListCache {
    public static final String STUDIO_REGISTERED_KEY = "StudioRegistered";
    public static final String CONNECT_CLIENT_CACHE_MINUTES_PROPERTY = "org.nuxeo.ecm.connect.client.cache";
    protected Map<String, PackageListCacheEntry> cache = new HashMap<String, PackageListCacheEntry>();
    protected int cache_duration = 5;

    public PackageListCache() {
        String cacheParam = NuxeoConnectClient.getProperty(CONNECT_CLIENT_CACHE_MINUTES_PROPERTY, "5");
        this.cache_duration = Integer.parseInt(cacheParam);
    }

    public void add(List<DownloadablePackage> pkgs, String type) {
        this.cache.put(type, new PackageListCacheEntry(pkgs));
    }

    public void add(DownloadablePackage pkg) {
        PackageListCacheEntry packageListCacheEntry = this.cache.get(pkg.getType().toString());
        if (packageListCacheEntry == null) {
            packageListCacheEntry = new PackageListCacheEntry();
            this.cache.put(pkg.getType().toString(), packageListCacheEntry);
        }
        packageListCacheEntry.getPackageCacheEntries().add(new PackageCacheEntry(pkg));
    }

    public List<DownloadablePackage> getFromCache(String type) {
        PackageListCacheEntry entry = this.cache.get(type);
        if (entry == null || entry.isExpired(this.cache_duration)) {
            return new ArrayList<DownloadablePackage>();
        }
        return entry.getPackages();
    }

    public DownloadablePackage getPackageByID(String packageId) {
        for (PackageListCacheEntry entry : this.cache.values()) {
            for (PackageCacheEntry pkgEntry : entry.getPackageCacheEntries()) {
                if (!packageId.equals(pkgEntry.getPackage().getId())) continue;
                if (pkgEntry.isExpired(this.cache_duration)) {
                    return null;
                }
                return pkgEntry.getPackage();
            }
        }
        return null;
    }

    @Deprecated
    public boolean isExpired(PackageListCacheEntry entry) {
        return entry.isExpired(this.cache_duration);
    }

    public boolean isExpired(PackageType type) {
        PackageListCacheEntry packageListCacheForType = this.cache.get(type.toString());
        return packageListCacheForType == null || packageListCacheForType.isExpired(this.cache_duration);
    }
}

