/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update;

import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;

public class PackageDependencyTest {
    @Test
    public void testGetters() {
        PackageDependency pd = new PackageDependency("foo");
        VersionRange vr = pd.getVersionRange();
        Assert.assertEquals((Object)"foo", (Object)pd.toString());
        Assert.assertEquals((Object)"foo", (Object)pd.getName());
        Assert.assertEquals((Object)VersionRange.ANY, (Object)vr);
        pd = new PackageDependency("foo:1.2");
        vr = pd.getVersionRange();
        Assert.assertEquals((Object)"foo:1.2.0", (Object)pd.toString());
        Assert.assertEquals((Object)"foo", (Object)pd.getName());
        Assert.assertEquals((Object)new Version("1.2.0"), (Object)vr.getMinVersion());
        Assert.assertNull((Object)vr.getMaxVersion());
        pd = new PackageDependency("foo:1.2:3.4.5");
        vr = pd.getVersionRange();
        Assert.assertEquals((Object)"foo:1.2.0:3.4.5", (Object)pd.toString());
        Assert.assertEquals((Object)"foo", (Object)pd.getName());
        Assert.assertEquals((Object)new Version("1.2.0"), (Object)vr.getMinVersion());
        Assert.assertEquals((Object)new Version("3.4.5"), (Object)vr.getMaxVersion());
    }

    @Test
    public void testEqualsAndHashCode() {
        PackageDependency pd1 = new PackageDependency("foo:1.2:3.4.5");
        PackageDependency pd2 = new PackageDependency("foo:1.2:3.4.5");
        PackageDependency pd3 = new PackageDependency("foo:1.2");
        Assert.assertTrue((boolean)pd1.equals((Object)pd2));
        Assert.assertFalse((boolean)pd1.equals((Object)pd3));
        Assert.assertFalse((boolean)pd2.equals((Object)pd3));
        Assert.assertTrue((pd1.hashCode() == pd2.hashCode() ? 1 : 0) != 0);
    }
}

