/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tests;

import java.util.List;
import junit.framework.TestCase;
import org.nuxeo.connect.DefaultCallbackHolder;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectConnector;
import org.nuxeo.connect.connector.http.ConnectHttpConnector;
import org.nuxeo.connect.connector.test.ConnectTestConnector;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.MockPackageUpdateService;
import org.nuxeo.connect.update.PackageUpdateService;

public class TestService
extends TestCase {
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("org.nuxeo.connect.client.testMode", "true");
        LogicalInstanceIdentifier.cleanUp();
        NuxeoConnectClient.resetPackageManager();
        ((DefaultCallbackHolder)NuxeoConnectClient.getCallBackHolder()).setUpdateService((PackageUpdateService)new MockPackageUpdateService(NuxeoConnectClient.getPackageManager()));
    }

    public void testServiceLookup() {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        TestService.assertNotNull((Object)crs);
        ConnectConnector connector = NuxeoConnectClient.getConnectConnector();
        TestService.assertNotNull((Object)connector);
    }

    public void testServiceAsUnregistered() {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        TestService.assertFalse((boolean)crs.isInstanceRegistered());
        ConnectConnector connector = NuxeoConnectClient.getConnectConnector();
        TestService.assertTrue((boolean)(connector instanceof ConnectHttpConnector));
    }

    public void testServiceAsRegistered() throws Exception {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        TestService.assertFalse((boolean)crs.isInstanceRegistered());
        crs.localRegisterInstance("toto--titi", "my test server");
        TestService.assertTrue((boolean)crs.isInstanceRegistered());
        ConnectConnector connector = NuxeoConnectClient.getConnectConnector();
        TestService.assertTrue((boolean)(connector instanceof ConnectHttpConnector));
    }

    public void testServiceAsTest() throws Exception {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        TestService.assertFalse((boolean)crs.isInstanceRegistered());
        ConnectConnector oldTestConnector = NuxeoConnectClient.getConnectGatewayComponent().getTestConnector();
        NuxeoConnectClient.getConnectGatewayComponent().setTestConnector((ConnectConnector)new ConnectTestConnector());
        ConnectConnector connector = NuxeoConnectClient.getConnectConnector();
        TestService.assertTrue((boolean)(connector instanceof ConnectTestConnector));
        NuxeoConnectClient.getConnectGatewayComponent().setTestConnector(oldTestConnector);
    }

    public void testDownloadService() throws Exception {
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        TestService.assertNotNull((Object)cdm);
    }

    public void testPackageManagerSimple() throws Exception {
        PackageManager pm = NuxeoConnectClient.getPackageManager();
        TestService.assertNotNull((Object)pm);
        for (PackageSource packageSource : pm.getAllSources()) {
            TestService.assertNotNull((Object)packageSource.listPackages());
            TestService.assertNotNull((Object)packageSource.listPackages(null, null));
            TestService.assertNotNull((Object)packageSource.listStudioPackages());
        }
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        crs.localRegisterInstance("toto--titi", "my test server");
        ConnectConnector oldTestConnector = NuxeoConnectClient.getConnectGatewayComponent().getTestConnector();
        NuxeoConnectClient.getConnectGatewayComponent().setTestConnector((ConnectConnector)new ConnectTestConnector());
        NuxeoConnectClient.getConnectGatewayComponent().getTestConnector().flushCache();
        List pkgs = pm.listPackages();
        TestService.assertEquals((int)3, (int)pkgs.size());
        NuxeoConnectClient.getConnectGatewayComponent().setTestConnector(oldTestConnector);
    }
}

