/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.PackageDescriptor;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.Version;

public class TestSerialization {
    private static final Log log = LogFactory.getLog(TestSerialization.class);

    @Test
    public void testSerializeSubscriptionStatus() throws JSONException {
        SubscriptionStatus status = new SubscriptionStatus();
        status.setEndDate("25/11/2011");
        status.setContractStatus("OK");
        status.setDescription("MyInstance");
        status.setInstanceType(NuxeoClientInstanceType.DEV);
        status.setMessage("Yo");
        String json = status.serializeAsJSON();
        Assert.assertNotNull((Object)json);
        log.info((Object)json);
        SubscriptionStatus s2 = (SubscriptionStatus)AbstractJSONSerializableData.loadFromJSON(SubscriptionStatus.class, (String)json);
        Assert.assertNotNull((Object)s2);
        Assert.assertEquals((Object)status.getContractStatus(), (Object)s2.getContractStatus());
        Assert.assertEquals((Object)status.getDescription(), (Object)s2.getDescription());
        Assert.assertEquals((Object)status.getEndDate(), (Object)s2.getEndDate());
        Assert.assertEquals((Object)status.getMessage(), (Object)s2.getMessage());
        Assert.assertEquals((Object)status.getInstanceType(), (Object)s2.getInstanceType());
    }

    protected void doTestSerializePackage(boolean cap) throws Exception {
        PackageDescriptor p = new PackageDescriptor();
        p.setClassifier("MyClassifier");
        p.setDescription("MyDescription");
        p.setName("testPackage");
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("5.3.0");
        targets.add("5.3.1");
        if (cap) {
            targets.add("cap-8.3");
        }
        p.setTargetPlatforms(targets);
        p.setTitle("My Title");
        p.setType(PackageType.STUDIO);
        p.setVersion(new Version(1, 0, 2));
        PackageDependency[] deps = new PackageDependency[]{new PackageDependency("my-package:1.1:1.2"), new PackageDependency("my-package:2.0:2.2")};
        p.setDependencies(deps);
        PackageDependency[] optDeps = new PackageDependency[]{new PackageDependency("my-opt-package:1.1:1.2"), new PackageDependency("my-opt-package:2.0:2.2")};
        p.setOptionalDependencies(optDeps);
        p.setCommentsNumber(8);
        p.setRating(4);
        p.setDownloadsCount(1000);
        p.setPackageState(PackageState.INSTALLED);
        p.setSupportsHotReload(true);
        String json = p.serializeAsJSON();
        Assert.assertNotNull((Object)json);
        log.info((Object)json);
        PackageDescriptor p2 = (PackageDescriptor)AbstractJSONSerializableData.loadFromJSON(PackageDescriptor.class, (String)json);
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((Object)p.getDescription(), (Object)p2.getDescription());
        Assert.assertEquals((Object)p.getClassifier(), (Object)p2.getClassifier());
        Assert.assertEquals((Object)p.getId(), (Object)p2.getId());
        Assert.assertEquals((Object)p.getName(), (Object)p2.getName());
        Assert.assertEquals((Object)p.getPackageState(), (Object)p2.getPackageState());
        Assert.assertEquals((Object)p.getTitle(), (Object)p2.getTitle());
        Assert.assertEquals((Object)p.getType(), (Object)p2.getType());
        Assert.assertEquals((Object)p.getVersion(), (Object)p2.getVersion());
        Assert.assertEquals((Object)p.getOptionalDependenciesAsString(), (Object)p2.getOptionalDependenciesAsString());
        Assert.assertEquals((long)p.getDownloadsCount(), (long)p2.getDownloadsCount());
        Assert.assertEquals((long)p.getRating(), (long)p2.getRating());
        Assert.assertEquals((long)p.getCommentsNumber(), (long)p2.getCommentsNumber());
        Assert.assertEquals((Object)PackageState.INSTALLED, (Object)p2.getPackageState());
        Assert.assertEquals((Object)true, (Object)p2.supportsHotReload());
        HashSet<String> expectedTargetPlatforms = new HashSet<String>(Arrays.asList("5.3.0", "5.3.1"));
        if (cap) {
            expectedTargetPlatforms.add("cap-8.3");
            expectedTargetPlatforms.add("server-8.3");
        }
        Assert.assertEquals(expectedTargetPlatforms, new HashSet<String>(Arrays.asList(p2.getTargetPlatforms())));
        HashSet<String> dependencies = new HashSet<String>();
        for (PackageDependency pd : p2.getDependencies()) {
            dependencies.add(pd.toString());
        }
        HashSet<String> expectedDependencies = new HashSet<String>(Arrays.asList("my-package:1.1.0:1.2.0", "my-package:2.0.0:2.2.0"));
        if (cap) {
            expectedDependencies.add("nuxeo-jsf-ui");
        }
        Assert.assertEquals(expectedDependencies, dependencies);
    }

    @Test
    public void testSerializePackage() throws Exception {
        this.doTestSerializePackage(false);
    }

    @Test
    public void testSerializePackageWithCap() throws Exception {
        this.doTestSerializePackage(true);
    }
}

